#include "available-stubs.h"

#include <gd.h>
#include "checker_api.h"

#undef HAVE_gdImageString16
#undef HAVE_gdImageStringUp16

#define CHECK_IMAGE(IMAGE) \
	stubs_chkr_check_addr (IMAGE, sizeof (gdImage), CHKR_RO, "image")
#define CHECK_FONT(FONT) \
	stubs_chkr_check_addr (FONT, sizeof (gdFont), CHKR_RO, "font")
#define CHKR_CHECK_STREAM(s) \
  stubs_chkr_check_addr (s, sizeof (FILE), CHKR_TW, "stream")

#ifdef HAVE_gdImageCreate
/* From `/usr/include/gd.h:85'.  */
gdImagePtr chkr_stub_gdImageCreate (int arg0, int arg1) __asm__ (CHKR_PREFIX ("gdImageCreate"));
gdImagePtr
chkr_stub_gdImageCreate (int arg0, int arg1)
{
  gdImagePtr res;
  res = gdImageCreate (arg0, arg1);
  if (res)
    stubs_chkr_set_right (res, sizeof (gdImage), CHKR_RO);
  return res;
}
#endif /* HAVE_gdImageCreate */

#ifdef HAVE_gdImageCreateFromGif
/* From `/usr/include/gd.h:86'.  */
gdImagePtr chkr_stub_gdImageCreateFromGif (FILE * arg0) __asm__ (CHKR_PREFIX ("gdImageCreateFromGif"));
gdImagePtr
chkr_stub_gdImageCreateFromGif (FILE * arg0)
{
  /* This function requires a stub */
  CHKR_CHECK_STREAM (arg0);
  {
    gdImagePtr res;
    res = gdImageCreateFromGif (arg0);
    if (res)
      stubs_chkr_set_right (res, sizeof (gdImage), CHKR_RO);
    return res;
  }
}
#endif /* HAVE_gdImageCreateFromGif */

#ifdef HAVE_gdImageCreateFromGd
/* From `/usr/include/gd.h:87'.  */
gdImagePtr chkr_stub_gdImageCreateFromGd (FILE * arg0) __asm__ (CHKR_PREFIX ("gdImageCreateFromGd"));
gdImagePtr
chkr_stub_gdImageCreateFromGd (FILE * arg0)
{
  CHKR_CHECK_STREAM (arg0);
  {
    gdImagePtr res;
    res = gdImageCreateFromGd (arg0);
    if (res)
      stubs_chkr_set_right (res, sizeof (gdImage), CHKR_RO);
    return res;
  }
}
#endif /* HAVE_gdImageCreateFromGd */

#ifdef HAVE_gdImageCreateFromXbm
/* From `/usr/include/gd.h:88'.  */
gdImagePtr chkr_stub_gdImageCreateFromXbm (FILE * arg0) __asm__ (CHKR_PREFIX ("gdImageCreateFromXbm"));
gdImagePtr
chkr_stub_gdImageCreateFromXbm (FILE * arg0)
{
  CHKR_CHECK_STREAM (arg0);
  {
    gdImagePtr res;
    res = gdImageCreateFromGd (arg0);
    if (res)
      stubs_chkr_set_right (res, sizeof (gdImage), CHKR_RO);
    return res;
  }
}
#endif /* HAVE_gdImageCreateFromXbm */

#ifdef HAVE_gdImageDestroy
/* From `/usr/include/gd.h:89'.  */
void chkr_stub_gdImageDestroy (gdImagePtr arg0) __asm__ (CHKR_PREFIX ("gdImageDestroy"));
void
chkr_stub_gdImageDestroy (gdImagePtr arg0)
{
  CHECK_IMAGE (arg0);
#if USE_BI_JUMP
  __builtin_jump (gdImageDestroy);
#else
  gdImageDestroy (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_gdImageDestroy */

#ifdef HAVE_gdImageSetPixel
/* From `/usr/include/gd.h:90'.  */
void chkr_stub_gdImageSetPixel (gdImagePtr arg0, int arg1, int arg2, int arg3) __asm__ (CHKR_PREFIX ("gdImageSetPixel"));
void
chkr_stub_gdImageSetPixel (gdImagePtr arg0, int arg1, int arg2, int arg3)
{
  CHECK_IMAGE (arg0);
#if USE_BI_JUMP
  __builtin_jump (gdImageSetPixel);
#else
  gdImageSetPixel (arg0, arg1, arg2, arg3);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_gdImageSetPixel */

#ifdef HAVE_gdImageGetPixel
/* From `/usr/include/gd.h:91'.  */
int chkr_stub_gdImageGetPixel (gdImagePtr arg0, int arg1, int arg2) __asm__ (CHKR_PREFIX ("gdImageGetPixel"));
int
chkr_stub_gdImageGetPixel (gdImagePtr arg0, int arg1, int arg2)
{
  CHECK_IMAGE (arg0);
#if USE_BI_JUMP
  __builtin_jump (gdImageGetPixel);
#else
  return gdImageGetPixel (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_gdImageGetPixel */

#ifdef HAVE_gdImageLine
/* From `/usr/include/gd.h:92'.  */
void chkr_stub_gdImageLine (gdImagePtr arg0, int arg1, int arg2, int arg3, int arg4, int arg5) __asm__ (CHKR_PREFIX ("gdImageLine"));
void
chkr_stub_gdImageLine (gdImagePtr arg0, int arg1, int arg2, int arg3, int arg4, int arg5)
{
  CHECK_IMAGE (arg0);
#if USE_BI_JUMP
  __builtin_jump (gdImageLine);
#else
  gdImageLine (arg0, arg1, arg2, arg3, arg4, arg5);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_gdImageLine */

#ifdef HAVE_gdImageDashedLine
/* From `/usr/include/gd.h:95'.  */
void chkr_stub_gdImageDashedLine (gdImagePtr arg0, int arg1, int arg2, int arg3, int arg4, int arg5) __asm__ (CHKR_PREFIX ("gdImageDashedLine"));
void
chkr_stub_gdImageDashedLine (gdImagePtr arg0, int arg1, int arg2, int arg3, int arg4, int arg5)
{
  CHECK_IMAGE (arg0);
#if USE_BI_JUMP
  __builtin_jump (gdImageDashedLine);
#else
  gdImageDashedLine (arg0, arg1, arg2, arg3, arg4, arg5);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_gdImageDashedLine */

#ifdef HAVE_gdImageRectangle
/* From `/usr/include/gd.h:98'.  */
void chkr_stub_gdImageRectangle (gdImagePtr arg0, int arg1, int arg2, int arg3, int arg4, int arg5) __asm__ (CHKR_PREFIX ("gdImageRectangle"));
void
chkr_stub_gdImageRectangle (gdImagePtr arg0, int arg1, int arg2, int arg3, int arg4, int arg5)
{
  CHECK_IMAGE (arg0);
#if USE_BI_JUMP
  __builtin_jump (gdImageRectangle);
#else
  gdImageRectangle (arg0, arg1, arg2, arg3, arg4, arg5);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_gdImageRectangle */

#ifdef HAVE_gdImageFilledRectangle
/* From `/usr/include/gd.h:100'.  */
void chkr_stub_gdImageFilledRectangle (gdImagePtr arg0, int arg1, int arg2, int arg3, int arg4, int arg5) __asm__ (CHKR_PREFIX ("gdImageFilledRectangle"));
void
chkr_stub_gdImageFilledRectangle (gdImagePtr arg0, int arg1, int arg2, int arg3, int arg4, int arg5)
{
  CHECK_IMAGE (arg0);
#if USE_BI_JUMP
  __builtin_jump (gdImageFilledRectangle);
#else
  gdImageFilledRectangle (arg0, arg1, arg2, arg3, arg4, arg5);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_gdImageFilledRectangle */

#ifdef HAVE_gdImageBoundsSafe
/* From `/usr/include/gd.h:101'.  */
int chkr_stub_gdImageBoundsSafe (gdImagePtr arg0, int arg1, int arg2) __asm__ (CHKR_PREFIX ("gdImageBoundsSafe"));
int
chkr_stub_gdImageBoundsSafe (gdImagePtr arg0, int arg1, int arg2)
{
  CHECK_IMAGE (arg0);
#if USE_BI_JUMP
  __builtin_jump (gdImageBoundsSafe);
#else
  return gdImageBoundsSafe (arg0, arg1, arg2);
  {
    int res;
    res = gdImageBoundsSafe (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_gdImageBoundsSafe */

#ifdef HAVE_gdImageChar
/* From `/usr/include/gd.h:102'.  */
void chkr_stub_gdImageChar (gdImagePtr arg0, gdFontPtr arg1, int arg2, int arg3, int arg4, int arg5) __asm__ (CHKR_PREFIX ("gdImageChar"));
void
chkr_stub_gdImageChar (gdImagePtr arg0, gdFontPtr arg1, int arg2, int arg3, int arg4, int arg5)
{
  CHECK_IMAGE (arg0);
  CHECK_FONT (arg1);
#if USE_BI_JUMP
  __builtin_jump (gdImageChar);
#else
  gdImageChar (arg0, arg1, arg2, arg3, arg4, arg5);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_gdImageChar */

#ifdef HAVE_gdImageCharUp
/* From `/usr/include/gd.h:103'.  */
void chkr_stub_gdImageCharUp (gdImagePtr arg0, gdFontPtr arg1, int arg2, int arg3, int arg4, int arg5) __asm__ (CHKR_PREFIX ("gdImageCharUp"));
void
chkr_stub_gdImageCharUp (gdImagePtr arg0, gdFontPtr arg1, int arg2, int arg3, int arg4, int arg5)
{
  CHECK_IMAGE (arg0);
  CHECK_FONT (arg1);
#if USE_BI_JUMP
  __builtin_jump (gdImageCharUp);
#else
  gdImageCharUp (arg0, arg1, arg2, arg3, arg4, arg5);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_gdImageCharUp */

#ifdef HAVE_gdImageString
/* From `/usr/include/gd.h:104'.  */
void chkr_stub_gdImageString (gdImagePtr arg0, gdFontPtr arg1, int arg2, int arg3, unsigned char * arg4, int arg5) __asm__ (CHKR_PREFIX ("gdImageString"));
void
chkr_stub_gdImageString (gdImagePtr arg0, gdFontPtr arg1, int arg2, int arg3, unsigned char * arg4, int arg5)
{
  CHECK_IMAGE (arg0);
  CHECK_FONT (arg1);
  stubs_chkr_check_str (arg4, CHKR_RO, "string");
  /* This function requires a stub */
#if USE_BI_JUMP
  __builtin_jump (gdImageString);
#else
  gdImageString (arg0, arg1, arg2, arg3, arg4, arg5);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_gdImageString */

#ifdef HAVE_gdImageStringUp
/* From `/usr/include/gd.h:105'.  */
void chkr_stub_gdImageStringUp (gdImagePtr arg0, gdFontPtr arg1, int arg2, int arg3, unsigned char * arg4, int arg5) __asm__ (CHKR_PREFIX ("gdImageStringUp"));
void
chkr_stub_gdImageStringUp (gdImagePtr arg0, gdFontPtr arg1, int arg2, int arg3, unsigned char * arg4, int arg5)
{
  CHECK_IMAGE (arg0);
  CHECK_FONT (arg1);
  stubs_chkr_check_str (arg4, CHKR_RO, "string");
#if USE_BI_JUMP
  __builtin_jump (gdImageStringUp);
#else
  gdImageStringUp (arg0, arg1, arg2, arg3, arg4, arg5);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_gdImageStringUp */

#ifdef HAVE_gdImageString16
/* From `/usr/include/gd.h:106'.  */
void chkr_stub_gdImageString16 (gdImagePtr arg0, gdFontPtr arg1, int arg2, int arg3, short unsigned int * arg4, int arg5) __asm__ (CHKR_PREFIX ("gdImageString16"));
void
chkr_stub_gdImageString16 (gdImagePtr arg0, gdFontPtr arg1, int arg2, int arg3, short unsigned int * arg4, int arg5)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg4, sizeof (short unsigned int), CHKR_XX, "arg4");
#if USE_BI_JUMP
  __builtin_jump (gdImageString16);
#else
  gdImageString16 (arg0, arg1, arg2, arg3, arg4, arg5);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_gdImageString16 */

#ifdef HAVE_gdImageStringUp16
/* From `/usr/include/gd.h:107'.  */
void chkr_stub_gdImageStringUp16 (gdImagePtr arg0, gdFontPtr arg1, int arg2, int arg3, short unsigned int * arg4, int arg5) __asm__ (CHKR_PREFIX ("gdImageStringUp16"));
void
chkr_stub_gdImageStringUp16 (gdImagePtr arg0, gdFontPtr arg1, int arg2, int arg3, short unsigned int * arg4, int arg5)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg4, sizeof (short unsigned int), CHKR_XX, "arg4");
#if USE_BI_JUMP
  __builtin_jump (gdImageStringUp16);
#else
  gdImageStringUp16 (arg0, arg1, arg2, arg3, arg4, arg5);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_gdImageStringUp16 */

#ifdef HAVE_gdImagePolygon
/* From `/usr/include/gd.h:115'.  */
void chkr_stub_gdImagePolygon (gdImagePtr arg0, gdPointPtr arg1, int arg2, int arg3) __asm__ (CHKR_PREFIX ("gdImagePolygon"));
void
chkr_stub_gdImagePolygon (gdImagePtr arg0, gdPointPtr arg1, int arg2, int arg3)
{
  CHECK_IMAGE (arg0);
  stubs_chkr_check_addr (arg1, arg2 * sizeof (gdPoint), CHKR_RO, "points");
#if USE_BI_JUMP
  __builtin_jump (gdImagePolygon);
#else
  gdImagePolygon (arg0, arg1, arg2, arg3);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_gdImagePolygon */

#ifdef HAVE_gdImageFilledPolygon
/* From `/usr/include/gd.h:116'.  */
void chkr_stub_gdImageFilledPolygon (gdImagePtr arg0, gdPointPtr arg1, int arg2, int arg3) __asm__ (CHKR_PREFIX ("gdImageFilledPolygon"));
void
chkr_stub_gdImageFilledPolygon (gdImagePtr arg0, gdPointPtr arg1, int arg2, int arg3)
{
  CHECK_IMAGE (arg0);
  stubs_chkr_check_addr (arg1, arg2 * sizeof (gdPoint), CHKR_RO, "points");
#if USE_BI_JUMP
  __builtin_jump (gdImageFilledPolygon);
#else
  gdImageFilledPolygon (arg0, arg1, arg2, arg3);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_gdImageFilledPolygon */

#ifdef HAVE_gdImageColorAllocate
/* From `/usr/include/gd.h:118'.  */
int chkr_stub_gdImageColorAllocate (gdImagePtr arg0, int arg1, int arg2, int arg3) __asm__ (CHKR_PREFIX ("gdImageColorAllocate"));
int
chkr_stub_gdImageColorAllocate (gdImagePtr arg0, int arg1, int arg2, int arg3)
{
  CHECK_IMAGE (arg0);
#if USE_BI_JUMP
  __builtin_jump (gdImageColorAllocate);
#else
  return gdImageColorAllocate (arg0, arg1, arg2, arg3);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_gdImageColorAllocate */

#ifdef HAVE_gdImageColorClosest
/* From `/usr/include/gd.h:119'.  */
int chkr_stub_gdImageColorClosest (gdImagePtr arg0, int arg1, int arg2, int arg3) __asm__ (CHKR_PREFIX ("gdImageColorClosest"));
int
chkr_stub_gdImageColorClosest (gdImagePtr arg0, int arg1, int arg2, int arg3)
{
  CHECK_IMAGE (arg0);
#if USE_BI_JUMP
  __builtin_jump (gdImageColorClosest);
#else
  return gdImageColorClosest (arg0, arg1, arg2, arg3);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_gdImageColorClosest */

#ifdef HAVE_gdImageColorExact
/* From `/usr/include/gd.h:120'.  */
int chkr_stub_gdImageColorExact (gdImagePtr arg0, int arg1, int arg2, int arg3) __asm__ (CHKR_PREFIX ("gdImageColorExact"));
int
chkr_stub_gdImageColorExact (gdImagePtr arg0, int arg1, int arg2, int arg3)
{
  CHECK_IMAGE (arg0);
#if USE_BI_JUMP
  __builtin_jump (gdImageColorExact);
#else
  return gdImageColorExact (arg0, arg1, arg2, arg3);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_gdImageColorExact */

#ifdef HAVE_gdImageColorDeallocate
/* From `/usr/include/gd.h:121'.  */
void chkr_stub_gdImageColorDeallocate (gdImagePtr arg0, int arg1) __asm__ (CHKR_PREFIX ("gdImageColorDeallocate"));
void
chkr_stub_gdImageColorDeallocate (gdImagePtr arg0, int arg1)
{
  CHECK_IMAGE (arg0);
#if USE_BI_JUMP
  __builtin_jump (gdImageColorDeallocate);
#else
  gdImageColorDeallocate (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_gdImageColorDeallocate */

#ifdef HAVE_gdImageColorTransparent
/* From `/usr/include/gd.h:122'.  */
void chkr_stub_gdImageColorTransparent (gdImagePtr arg0, int arg1) __asm__ (CHKR_PREFIX ("gdImageColorTransparent"));
void
chkr_stub_gdImageColorTransparent (gdImagePtr arg0, int arg1)
{
  CHECK_IMAGE (arg0);
#if USE_BI_JUMP
  __builtin_jump (gdImageColorTransparent);
#else
  gdImageColorTransparent (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_gdImageColorTransparent */

#ifdef HAVE_gdImageGif
/* From `/usr/include/gd.h:123'.  */
void chkr_stub_gdImageGif (gdImagePtr arg0, FILE * arg1) __asm__ (CHKR_PREFIX ("gdImageGif"));
void
chkr_stub_gdImageGif (gdImagePtr arg0, FILE * arg1)
{
  /* This function requires a stub */
  CHECK_IMAGE (arg0);
  CHKR_CHECK_STREAM (arg1);
#if USE_BI_JUMP
  __builtin_jump (gdImageGif);
#else
  gdImageGif (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_gdImageGif */

#ifdef HAVE_gdImageGd
/* From `/usr/include/gd.h:124'.  */
void chkr_stub_gdImageGd (gdImagePtr arg0, FILE * arg1) __asm__ (CHKR_PREFIX ("gdImageGd"));
void
chkr_stub_gdImageGd (gdImagePtr arg0, FILE * arg1)
{
  /* This function requires a stub */
  CHECK_IMAGE (arg0);
  CHKR_CHECK_STREAM (arg1);
#if USE_BI_JUMP
  __builtin_jump (gdImageGd);
#else
  gdImageGd (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_gdImageGd */

#ifdef HAVE_gdImageArc
/* From `/usr/include/gd.h:125'.  */
void chkr_stub_gdImageArc (gdImagePtr arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7) __asm__ (CHKR_PREFIX ("gdImageArc"));
void
chkr_stub_gdImageArc (gdImagePtr arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7)
{
  CHECK_IMAGE (arg0);
#if USE_BI_JUMP
  __builtin_jump (gdImageArc);
#else
  gdImageArc (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_gdImageArc */

#ifdef HAVE_gdImageFillToBorder
/* From `/usr/include/gd.h:126'.  */
void chkr_stub_gdImageFillToBorder (gdImagePtr arg0, int arg1, int arg2, int arg3, int arg4) __asm__ (CHKR_PREFIX ("gdImageFillToBorder"));
void
chkr_stub_gdImageFillToBorder (gdImagePtr arg0, int arg1, int arg2, int arg3, int arg4)
{
  CHECK_IMAGE (arg0);
#if USE_BI_JUMP
  __builtin_jump (gdImageFillToBorder);
#else
  gdImageFillToBorder (arg0, arg1, arg2, arg3, arg4);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_gdImageFillToBorder */

#ifdef HAVE_gdImageFill
/* From `/usr/include/gd.h:127'.  */
void chkr_stub_gdImageFill (gdImagePtr arg0, int arg1, int arg2, int arg3) __asm__ (CHKR_PREFIX ("gdImageFill"));
void
chkr_stub_gdImageFill (gdImagePtr arg0, int arg1, int arg2, int arg3)
{
  CHECK_IMAGE (arg0);
#if USE_BI_JUMP
  __builtin_jump (gdImageFill);
#else
  gdImageFill (arg0, arg1, arg2, arg3);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_gdImageFill */

#ifdef HAVE_gdImageCopy
/* From `/usr/include/gd.h:128'.  */
void chkr_stub_gdImageCopy (gdImagePtr arg0, gdImagePtr arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7) __asm__ (CHKR_PREFIX ("gdImageCopy"));
void
chkr_stub_gdImageCopy (gdImagePtr arg0, gdImagePtr arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7)
{
  CHECK_IMAGE (arg0);
  CHECK_IMAGE (arg1);
#if USE_BI_JUMP
  __builtin_jump (gdImageCopy);
#else
  gdImageCopy (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_gdImageCopy */

#ifdef HAVE_gdImageCopyResized
/* From `/usr/include/gd.h:130'.  */
void chkr_stub_gdImageCopyResized (gdImagePtr arg0, gdImagePtr arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9) __asm__ (CHKR_PREFIX ("gdImageCopyResized"));
void
chkr_stub_gdImageCopyResized (gdImagePtr arg0, gdImagePtr arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9)
{
  CHECK_IMAGE (arg0);
  CHECK_IMAGE (arg1);
#if USE_BI_JUMP
  __builtin_jump (gdImageCopyResized);
#else
  gdImageCopyResized (arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_gdImageCopyResized */

#ifdef HAVE_gdImageSetBrush
/* From `/usr/include/gd.h:131'.  */
void chkr_stub_gdImageSetBrush (gdImagePtr arg0, gdImagePtr arg1) __asm__ (CHKR_PREFIX ("gdImageSetBrush"));
void
chkr_stub_gdImageSetBrush (gdImagePtr arg0, gdImagePtr arg1)
{
  CHECK_IMAGE (arg0);
  CHECK_IMAGE (arg1);
#if USE_BI_JUMP
  __builtin_jump (gdImageSetBrush);
#else
  gdImageSetBrush (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_gdImageSetBrush */

#ifdef HAVE_gdImageSetTile
/* From `/usr/include/gd.h:132'.  */
void chkr_stub_gdImageSetTile (gdImagePtr arg0, gdImagePtr arg1) __asm__ (CHKR_PREFIX ("gdImageSetTile"));
void
chkr_stub_gdImageSetTile (gdImagePtr arg0, gdImagePtr arg1)
{
  CHECK_IMAGE (arg0);
  CHECK_IMAGE (arg1);
#if USE_BI_JUMP
  __builtin_jump (gdImageSetTile);
#else
  gdImageSetTile (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_gdImageSetTile */

#ifdef HAVE_gdImageSetStyle
/* From `/usr/include/gd.h:133'.  */
void chkr_stub_gdImageSetStyle (gdImagePtr arg0, int * arg1, int arg2) __asm__ (CHKR_PREFIX ("gdImageSetStyle"));
void
chkr_stub_gdImageSetStyle (gdImagePtr arg0, int * arg1, int arg2)
{
  CHECK_IMAGE (arg0);
  stubs_chkr_check_addr (arg1, sizeof (int) * arg2, CHKR_RO, "style");
#if USE_BI_JUMP
  __builtin_jump (gdImageSetStyle);
#else
  gdImageSetStyle (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_gdImageSetStyle */

#ifdef HAVE_gdImageInterlace
/* From `/usr/include/gd.h:135'.  */
void chkr_stub_gdImageInterlace (gdImagePtr arg0, int arg1) __asm__ (CHKR_PREFIX ("gdImageInterlace"));
void
chkr_stub_gdImageInterlace (gdImagePtr arg0, int arg1)
{
  CHECK_IMAGE (arg0);
#if USE_BI_JUMP
  __builtin_jump (gdImageInterlace);
#else
  gdImageInterlace (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_gdImageInterlace */

