#ifndef _I386_BITOPS_H
#define _I386_BITOPS_H

/* From linux asm-i386/bitops.h.  */
/*
 * Copyright 1992, Linus Torvalds.
 */

/*
 * These have to be done with inline assembly: that way the bit-setting
 * is guaranteed to be atomic. All bit operations return 0 if the bit
 * was cleared before the operation and != 0 if it was not.
 *
 * bit 0 is the LSB of addr; bit 32 is the LSB of (addr+1).
 */

#ifdef __SMP__
#define SMPVOL volatile
#else
#define SMPVOL
#endif

extern int set_bit(int nr, SMPVOL void * addr);
extern int clear_bit(int nr, SMPVOL void * addr);
extern int change_bit(int nr, SMPVOL void * addr);
extern int test_bit(int nr, const SMPVOL void * addr);
extern int find_first_zero_bit(void * addr, unsigned size);
extern int find_next_zero_bit (void * addr, int size, int offset);
extern unsigned long ffz(unsigned long word);

#endif /* _I386_BITOPS_H */
