procedure err(s:string);
begin
  if run1=1 then write(dialect,'.',run2:1,': ') else write('Run #',run1:1,'.',run2:1,': ');
  writeln(s);
  OK:=False
end;

{$define TO1(typ,vr)
  if IOResult<>0 then err('unexpected I/O error while reading '+typ+' variable')
}
{$define TO(typ,vr,val)
  begin TO1(typ,vr) else if not (vr=val) then begin writestr(tmpstr,'value of '+typ+' variable is `',vr,''', but should be `',val,'''');err(tmpstr) end end
}

{$define TW(typ,vr)
  begin if IOResult=0 then err('unexpected I/O success while reading '+typ+' variable') end
}

{$define GO1(typ,vr) begin get(vr);TO1(typ,vr) end}
{$define GO(typ,vr,val) begin get(vr);TO(typ,vr,val) end}
{$define GW(typ,vr) begin get(vr);TW(typ,vr) end}

{$define testint(typ,var)
  GO(typ,var,42);
  if Hex  then GO(typ+' (Hex)',var,62) else GW(typ+' (Hex)',var);
  if Base then GO(typ+' (Base)',var,93) else GW(typ+' (Base)',var);
  if White then GO(typ+' (White)',var,24) else GW(typ+' (White)',var);
  if White and Hex then GO(typ+' (White, Hex)',var,17) else GW(typ+' (White, Hex)',var);
  if White and Base then GO(typ+' (White, Base)',var,116) else GW(typ+' (White, Base)',var);
  GW(typ+' (Invalid)',var);
  if not RangeCheck then GO1(typ+' (Range)',var) else GW(typ+' (Range)',var)
}

{$define testreal(typ,var)
  GO(typ+' (1)',var,173.25);
  GO(typ+' (2)',var,-17326000);
  GW(typ+' (Invalid)',var);
  GO(typ+' (3)',var,-0.125);
  if not RealIso7185 then GO(typ+' (EP, 1)',var,0.5) else GW(typ+' (EP, 1)',var);
  if not RealIso7185 then GO(typ+' (EP, 2)',var,-0.25) else GW(typ+' (EP, 2)',var);
  if White then GO(typ+' (White)',var,-2.3e16) else GW(typ+' (White)',var);
  if White and not RealIso7185 then GO(typ+' (White, EP)',var,2e-14) else GW(typ+' (White, EP)',var);
}

{$define testnum
  inc(run2);
  reset(infile);
  if IOResult<>0 then begin writeln('Could not open input file.'); Halt(1) end;
  testint('ByteInt',bi);
  testint('ShortInt',si);
  testint('Integer',ni);
  testint('MedInt',mi);
  testint('LongInt',li);
  testint('Byte',bc);
  testint('ShortCard',sc);
  testint('Cardinal',nc);
  testint('MedCard',mc);
  testint('LongCard',lc);
  testreal('ShortReal',sr);
  testreal('Real',nr);
  testreal('LongReal',lr);
}

{$ifdef Standard}
{$define testcstring}
{$else}
{$define testcstring
  get(cst);TO1('CString',cst) else if strcmp(cst,'fof')<>0 then begin writestr(tmpstr,'value of CString variable is `',cst,''', but should be `fof''');err(tmpstr) end
}
{$endif}

{$define testall
  testnum;
  GO('Char',c,'a');
  GO('Char',c,chr(0));
  get2(c,c2);
  TO('Char (1)',c,'f');
  TO('Char (2)',c2,'o');
  GO('Char (R)',cr,'M');
  if not RangeCheck then GO1('Char (Range)',cr) else GW('Char (Range)',cr);
  GO('String',nst,'foo'+Chr(0)+'b ar ');
  GO('ShortString',sst,'oof'+Chr(0)+'ra b ');
  GO('FixedString',fst,'ofo'+Chr(0)+'ba r');
  testcstring
}

procedure r;
begin
  {$i-}
  run1:=0;
  {$i readsub.inc}
  {$no-read-base-specifier}
  {$no-read-white-space}
  {$no-read-range-checking}
  rangecheck:=False;
  base      :=False;
  hex       :=False;
  whitespace:=False;
  {$i readsub.inc}
  {$read-base-specifier}
  {$read-white-space}
  {$read-range-checking}
  rangecheck:=True;
  base      :=True;
  hex       :=True;
  whitespace:=True;
  {$i readsub.inc}
  {$i+}
end;

{$gnu-pascal}

procedure test;
var i:Integer;
begin

  Writeln ('Failed. (This plain message is output so that the program does not generate');
  Writeln ('a big number of messages. When the problems are fixed, remove this message.)');
  Halt (1);

  Rewrite(infile);
  for i:=1 to 10 do
    begin
      writeln(infile,'42');
      writeln(infile,'$3e');
      writeln(infile,'19#4h');
      writeln(infile,' 24');
      writeln(infile,#9'$000000011');
      writeln(infile,'  '#9#9'  11#A6');
      writeln(infile,'foo');
      if i=10 then writeln(infile,'-1') else writeln(infile,'10000000000000000000')
    end;
  for i:=1 to 3 do
    begin
      writeln(infile,'17.325e1');
      writeln(infile,'-17.326E6');
      writeln(infile,'one point two');
      writeln(infile,'-125e-3');
      writeln(infile,'.5');
      writeln(infile,'-.25');
      writeln(infile,'   -23e15');
      writeln(infile,#9#9'.2e-13');
    end;
  writeln(infile,'a');
  writeln(infile,#0);
  writeln(infile,'fo');
  writeln(infile,'M');
  writeln(infile,'m');
  writeln(infile,'foo'#0'b ar ');
  writeln(infile,'oof'#0'ra b ');
  writeln(infile,'ofo'#0'ba r ');
  writeln(infile,'fof'#0'r ab ');
  OK:=True;
  r;
  if OK then Writeln('OK')
end;
