/* Definitions for switches for Pascal.
   Copyright (C) 1997 Free Software Foundation, Inc.

This file is part of GNU Pascal.

GNU Pascal is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Pascal is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Pascal; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

/* This is the contribution to the `lang_options' array in gcc.c for
   gpc.  */

#include "gcc-version.h"

#ifdef EGCS
DEFINE_LANG_NAME ("Pascal")
#endif

#ifndef GPC_OPT
# ifdef EGCS
#  define GPC_OPT(NAME, DESCRIPTION) { NAME, DESCRIPTION }
# else
#  define GPC_OPT(NAME, DESCRIPTION) NAME
# endif
#endif

  GPC_OPT ("-fstandard-pascal-level-0",
           "Reject conformant arrays and anything besides ISO-7185 Standard Pascal"),
  GPC_OPT ("-fstandard-pascal",
           "Reject anything besides ISO-7185 Standard Pascal"),
  GPC_OPT ("-fextended-pascal",
           "Reject anything besides (the implemented parts of) ISO-10206 Extended Pascal"),
  GPC_OPT ("-fobject-pascal",
           "Reject anything besides (the implemented parts of) ANSI draft Object Pascal"),
  GPC_OPT ("-fborland-pascal",
           "Try to emulate Borland Pascal, version 7.0"),
  GPC_OPT ("-fdelphi",
           "Try to emulate Borland Pascal, version 7.0, with some Delphi extensions"),
  GPC_OPT ("-fpascal-sc",
           "Be strict about the implemented Pascal-SC extensions"),
  GPC_OPT ("-fgnu-pascal",
           "Undo the effect of a previous `--foo-pascal', `--delphi' or `pascal-sc' switch"),
  GPC_OPT ("-flines",
           "(Unimplemented switch for debugging)"),
  GPC_OPT ("-fdebug-tree",
           "(Internal directive for debugging the compiler)"),
  GPC_OPT ("-fdebug-gpi",
           "(Internal directive for debugging the compiler)"),
  GPC_OPT ("-fdebug-source",
           "(Internal directive for debugging the compiler)"),
  GPC_OPT ("-fautolink",
           "Automatically link object files provided by Units/Modules or {$L ...} (default)"),
  GPC_OPT ("-fno-autolink",
           "Do not automatically link object files provided by Units/Modules/{$L ...}"),
  GPC_OPT ("-fautomake",
           "Automatically compile changed Units/Modules/{$L ...} files and link the object files provided"),
  GPC_OPT ("-fno-automake",
           "Same as `--no-autolink'"),
  GPC_OPT ("-fautobuild",
           "Automatically compile all Units/Modules/{$L ...} files and link the object files provided"),
  GPC_OPT ("-fno-autobuild",
           "Same as `--no-autolink'"),
  GPC_OPT ("-famtmpfile",
           "(Internal switch used for AutoMake)"),
  GPC_OPT ("-fextended-syntax",
           "Enable \"extended syntax\" (same as {$x+})"),
  GPC_OPT ("-fno-extended-syntax",
           "Disable \"extended syntax\" (same as {$x-})"),
  GPC_OPT ("-fsigned-char",
           "Let `char' be a signed type"),
  GPC_OPT ("-fno-signed-char",
           "Let `char' be an unsigned type"),
  GPC_OPT ("-funsigned-char",
           "Let `char' be an unsigned type"),
  GPC_OPT ("-fno-unsigned-char",
           "Let `char' be a signed type"),
  GPC_OPT ("-fchar-escapes",
           "Allow for C-style character escapes (like `\\n')"),
  GPC_OPT ("-fno-char-escapes",
           "Do not handle C-style character escapes (default)"),
  GPC_OPT ("-fc-numbers",
           "Allow for C-style octal (0755) and hex (0xFF) numbers"),
  GPC_OPT ("-fno-c-numbers",
           "Do not allow C-style octal and hex numbers (default)"),
  GPC_OPT ("-fshort-circuit",
           "Guarantee short-circuit Boolean evaluation (default; same as {$b-})"),
  GPC_OPT ("-fno-short-circuit",
           "Do not guarantee short-circuit Boolean evaluation (same as {$b+})"),
  GPC_OPT ("-fnested-comments",
           "Allow {...} comments being nested in (*...*) and vice versa"),
  GPC_OPT ("-fno-nested-comments",
           "Allow comments like {...*) (default with strict ISO)"),
  GPC_OPT ("-fignore-function-results",
           "Do not complain when a function is called like a procedure"),
  GPC_OPT ("-fno-ignore-function-results",
           "Complain when a function is called like a procedure (default)"),
  GPC_OPT ("-fborland-char-constants",
           "Allow for Borland-style character constants like #27 or ^L"),
  GPC_OPT ("-fno-borland-char-constants",
           "Reject Borland-style character constants like #27 or ^L"),
  GPC_OPT ("-ftruncate-strings",
           "Truncate strings being assigned to other strings of too short capacity."),
  GPC_OPT ("-fno-truncate-strings",
           "Treat string assignments to other strings of too short capacity as errors."),
  GPC_OPT ("-fexact-compare-strings",
           "Do not blank-pad strings for comparisons"),
  GPC_OPT ("-fno-exact-compare-strings",
           "Blank-pad strings for comparisons"),
  GPC_OPT ("-fio-checking",
           "Do automatic run-time checks after I/O operations"),
  GPC_OPT ("-fno-io-checking",
           "Do not check I/O operations automatically; use `IOResult' manually"),
  GPC_OPT ("-fwrite-clip-strings",
           "Truncate strings exceeding their field width: `write ( 'foobar' : 3 )'"),
  GPC_OPT ("-fno-write-clip-strings",
           "Do not truncate strings exceeding their field width"),
  GPC_OPT ("-fwrite-real-blank",
           "Output a blank in front of positive reals in exponential form (default)"),
  GPC_OPT ("-fno-write-real-blank",
           "Do not output a blank in front of positive reals in exponential form"),
  GPC_OPT ("-fwrite-capital-exponent",
           "Write real exponents with a capital `E'"),
  GPC_OPT ("-fno-write-capital-exponent",
           "Write real exponents with a lowercase `e'"),
  GPC_OPT ("-ftransparent-file-names",
           "Derive external file names from variable names"),
  GPC_OPT ("-fno-transparent-file-names",
           "Do not derive external file names from variable names (default)"),
  GPC_OPT ("-ffield-widths",
           "Comma-separated list of default field widths for Integer, Real, Boolean, LongInt, LongReal"),
  GPC_OPT ("-fno-field-widths",
           "Reset the default field widths"),
  GPC_OPT ("-fsetlimit",
           "Range for `set of integer'"),
  GPC_OPT ("-fgpc-main",
           "Internal name for the program's entry point (default: `main')"),
  GPC_OPT ("-finterface-only",
           "Compile only the interface part of a Unit/Module and exit"),
  GPC_OPT ("-fimplementation-only",
           "Do not produce a GPI file; only compile the implementation part"),
  GPC_OPT ("-fexecutable-file-name",
           "Name for the output file, if specified; otherwise derive from main source file name"),
  GPC_OPT ("-funit-path",
           "Directories where to look for Unit/Module sources"),
  GPC_OPT ("-fno-unit-path",
           "Forget about directories where to look for Unit/Module sources"),
  GPC_OPT ("-fobject-path",
           "Directories where to look for additional object (and source) files"),
  GPC_OPT ("-fno-object-path",
           "Forget about directories where to look for additional object (and source) files"),
  GPC_OPT ("-fexecutable-path",
           "Path where to create the executable file"),
  GPC_OPT ("-fno-executable-path",
           "Create the executable file in the directory where the main source is (default)"),
  GPC_OPT ("-funit-destination-path",
           "Path where to create object and GPI files"),
  GPC_OPT ("-fno-unit-destination-path",
           "Create object and GPI files in the current directory (default)"),
  GPC_OPT ("-fobject-destination-path",
           "Path where to create additional object files"),
  GPC_OPT ("-fno-object-destination-path",
           "Create additional object files in the current directory (default)"),
  GPC_OPT ("-fno-default-paths",
           "Do not add a default path to the unit and object path"),
  GPC_OPT ("-fgpi-destination-path",
           "(Internal switch used for AutoMake)"),
  GPC_OPT ("-fuses",
           "Add an implicit `uses' clause"),
  GPC_OPT ("-Wtyped-const",
           "Warn about misused of typed constants as initialized variables (default)"),
  GPC_OPT ("-Wno-typed-const",
           "Do not warn about misused of typed constants as initialized variables"),
  GPC_OPT ("-Wnear-far",
           "Warn about use of useless `near' or `far' directives (default)"),
  GPC_OPT ("-Wno-near-far",
           "Do not warn about use of useless `near' or `far' directives"),
