/*
GPC demo code. C wrapper code for filelockdemo.pas.

Copyright (C) 1999 Free Software Foundation, Inc.

Author: Frank Heckenbach <frank@pascal.gnu.de>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING. If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.

As a special exception, if you incorporate even large parts of the
code of this demo program into another program with substantially
different functionality, this does not cause the other program to
be covered by the GNU General Public License. This exception does
not however invalidate any other reasons why it might be covered
by the GNU General Public License.
*/

#include <unistd.h>
#include <stdio.h>
#include <signal.h>
#include <sys/file.h>

typedef unsigned char Boolean;

int filelock (int, Boolean, Boolean);
int filelock (int FHandle, Boolean Exclusive, Boolean DontBlock)
{
  return flock (FHandle, (Exclusive ? LOCK_EX : LOCK_SH) | (DontBlock ? LOCK_NB : 0));
}

int fileunlock (int);
int fileunlock (int FHandle)
{
  return flock (FHandle, LOCK_UN);
}

int settimeraction (int Seconds, void (*Proc)(int));
int settimeraction (int Seconds, void (*Proc)(int))
{
  alarm (Seconds);
  return signal (SIGALRM, Proc) == SIG_ERR ? -1 : 0;
}
