{
    $Id: stre.inc,v 1.8 1999/08/28 14:53:27 florian Exp $
    This file is part of the Free Pascal run time library.
    Copyright (c) 1998 by the Free Pascal development team

    This file implements english error message strings
    
    See the file COPYING.FPC, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}

{
  English string constants for any messages issued by the sysutils unit.
  Please have them ordered by constant name.
}

Const

   { Error messages for exceptions }
   
   SAbstractError = 'Abstract method called';
   SAccessDenied = 'Access denied';
   SAccessViolation = 'Access violation';
   SArgumentMissing = 'Missing argument in format "%s"';
   SAssertError = '%s (%s, line %d)';
   SAssertionFailed = 'Assertion failed';
   SDiskFull = 'Disk Full';
   SDivByZero = 'Division by zero';
   SEndOfFile = 'Read past end of file';
   SFileNotFound = 'File not found';
   SFileNotAssigned = 'File not assigned';
   SFileNotOpen = 'File not open';
   SFileNotOpenForInput = 'File not open for input';
   SFileNotOpenForOutput = 'File not open for output';
   SInvalidArgIndex = 'Invalid argument index in format "%s"';
   SInvalidDrive = 'Invalid drive specified';
   SInvalidFileHandle = 'Invalid file handle';
   SInValidFileName = 'Invalid filename';
   SInvalidFloat = '"%s" is an invalid float';
   SInvalidFormat = 'Invalid format specifier : "%s"';
   SInvalidInput = 'Invalid input';
   SInvalidInteger = '"%s" is an invalid integer';
   SInvalidPointer = 'Invalid pointer operation';
   SOutOfMemory = 'Out of memory';
   SRangeError = 'Range check error';
   SInvalidCast = 'Invalid type cast';
   STooManyOpenFiles = 'Too many open files';
   SUnKnownRunTimeError = 'Unknown Run-Time error : %3.3d';
   SOverflow = 'Floating point overflow';
   SUnderflow = 'Floating point underflow';
   SIntOverflow = 'Arithmetic overflow';
   SInvalidOp = 'Invalid floating point operation';
{
  $Log: stre.inc,v $
  Revision 1.8  1999/08/28 14:53:27  florian
    * bug 471 fixed: run time error 2 is now converted into a file not
      found exception

  Revision 1.7  1999/07/02 17:03:22  florian
    + added some runtime->excpetin wrappers: eintoverflow, eoverflow, eunderflow, einvalidop

  Revision 1.6  1999/06/19 07:39:46  michael
  Implemented strtofloat

  Revision 1.5  1998/10/10 09:53:09  michael
  Added assertion handling

  Revision 1.4  1998/10/03 15:08:04  florian
    * EInvalidCast added (from runerror 219)

  Revision 1.3  1998/10/02 13:57:37  michael
  Format error now causes exception

  Revision 1.2  1998/10/02 13:00:09  michael
  + More RTL error handling

  Revision 1.1  1998/10/01 16:04:59  michael
  + Initial implementation

}   
