-- Copyright 1999 Pirmin Kalberer and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "GTK_CTREE - a multi-column tree"
	cvs: "$Id: gtk_ctree.e,v 1.4 1999/09/09 15:00:50 olly Exp $"

class GTK_CTREE

-- A multi-column tree widget.  This is a self-scrolling widget;
-- to get scrollbars, simply make it a child of a GTK_SCROLLED_WINDOW.
--
-- Signals (from gtkctree.c):
--    "change_focus_row_expansion"
--    "tree_collapse"
--    "tree_expand"
--    "tree_move"
--    "tree_select_row"
--    "tree_unselect_row"

inherit
	
   GTK_CLIST
      rename
	 make as make_clist
      end
	
   GTK_CTREE_EXTERNALS
      undefine
	 copy, is_equal
      end

creation
	
	make,
	make_from_pointer
	
feature
	
	make ( columns, tree_column : INTEGER ) is 
		do
			widget := gtk_ctree_new ( columns, tree_column )
			register_widget
		end
	
feature -- native GTK calls (UNTESTED) - TODO: replace POINTER types

   construct ( columns : INTEGER; tree_column : INTEGER; titles : POINTER ) is
      do
         gtk_ctree_construct ( widget, columns, tree_column, titles )
      end

   new_with_titles ( columns, tree_column : INTEGER; titles : POINTER ) : POINTER is
      do
         Result := gtk_ctree_new_with_titles ( columns, tree_column, titles )
      end

   insert_node ( parent_node : POINTER; sibling : POINTER; text : POINTER; spacing : INTEGER; pixmap_closed : POINTER; mask_closed : POINTER; pixmap_opened : POINTER; mask_opened : POINTER; is_leaf : BOOLEAN; is_expanded : BOOLEAN ) : POINTER is
      do
         Result := gtk_ctree_insert_node ( widget, parent_node, sibling, text, spacing, pixmap_closed, mask_closed, pixmap_opened, mask_opened, is_leaf, is_expanded )
      end

   remove_node ( node : POINTER ) is
      do
         gtk_ctree_remove_node ( widget, node )
      end

--    insert_gnode ( parent_node : POINTER; sibling : POINTER; gnode : POINTER; func : POINTER; data : POINTER ) : POINTER is
--       do
--          Result := gtk_ctree_insert_gnode ( widget, parent_node, sibling, gnode, func, data )
--       end

--    export_to_gnode ( parent_node : POINTER; sibling : POINTER; node : POINTER; func : POINTER; data : POINTER ) : POINTER is
--       do
--          Result := gtk_ctree_export_to_gnode ( widget, parent_node, sibling, node, func, data )
--       end

--    post_recursive ( node : POINTER; func : POINTER; data : POINTER ) is
--       do
--          gtk_ctree_post_recursive ( widget, node, func, data )
--       end

--    post_recursive_to_depth ( node : POINTER; depth : INTEGER; func : POINTER; data : POINTER ) is
--       do
--          gtk_ctree_post_recursive_to_depth ( widget, node, depth, func, data )
--       end

--    pre_recursive ( node : POINTER; func : POINTER; data : POINTER ) is
--       do
--          gtk_ctree_pre_recursive ( widget, node, func, data )
--       end

--    pre_recursive_to_depth ( node : POINTER; depth : INTEGER; func : POINTER; data : POINTER ) is
--       do
--          gtk_ctree_pre_recursive_to_depth ( widget, node, depth, func, data )
--       end

   is_viewable ( node : POINTER ) : BOOLEAN is
      do
         Result := gtk_ctree_is_viewable ( widget, node )
      end

   last ( node : POINTER ) : POINTER is
      do
         Result := gtk_ctree_last ( widget, node )
      end

   find_node_ptr ( ctree_row : POINTER ) : POINTER is
      do
         Result := gtk_ctree_find_node_ptr ( widget, ctree_row )
      end

   node_nth ( row : INTEGER ) : POINTER is
      do
         Result := gtk_ctree_node_nth ( widget, row )
      end

   find ( node : POINTER; child : POINTER ) : BOOLEAN is
      do
         Result := gtk_ctree_find ( widget, node, child )
      end

   is_ancestor ( node : POINTER; child : POINTER ) : BOOLEAN is
      do
         Result := gtk_ctree_is_ancestor ( widget, node, child )
      end

   find_by_row_data ( node : POINTER; data : POINTER ) : POINTER is
      do
         Result := gtk_ctree_find_by_row_data ( widget, node, data )
      end

   find_all_by_row_data ( node : POINTER; data : POINTER ) : POINTER is
      do
         Result := gtk_ctree_find_all_by_row_data ( widget, node, data )
      end

--    find_by_row_data_custom ( node : POINTER; data : POINTER; func : POINTER ) : POINTER is
--       do
--          Result := gtk_ctree_find_by_row_data_custom ( widget, node, data, func )
--       end

--    find_all_by_row_data_custom ( node : POINTER; data : POINTER; func : POINTER ) : POINTER is
--       do
--          Result := gtk_ctree_find_all_by_row_data_custom ( widget, node, data, func )
--       end

   is_hot_spot ( x : INTEGER; y : INTEGER ) : BOOLEAN is
      do
         Result := gtk_ctree_is_hot_spot ( widget, x, y )
      end

   move ( node : POINTER; new_parent : POINTER; new_sibling : POINTER ) is
      do
         gtk_ctree_move ( widget, node, new_parent, new_sibling )
      end

   expand ( node : POINTER ) is
      do
         gtk_ctree_expand ( widget, node )
      end

   expand_recursive ( node : POINTER ) is
      do
         gtk_ctree_expand_recursive ( widget, node )
      end

   expand_to_depth ( node : POINTER; depth : INTEGER ) is
      do
         gtk_ctree_expand_to_depth ( widget, node, depth )
      end

   collapse ( node : POINTER ) is
      do
         gtk_ctree_collapse ( widget, node )
      end

   collapse_recursive ( node : POINTER ) is
      do
         gtk_ctree_collapse_recursive ( widget, node )
      end

   collapse_to_depth ( node : POINTER; depth : INTEGER ) is
      do
         gtk_ctree_collapse_to_depth ( widget, node, depth )
      end

   toggle_expansion ( node : POINTER ) is
      do
         gtk_ctree_toggle_expansion ( widget, node )
      end

   toggle_expansion_recursive ( node : POINTER ) is
      do
         gtk_ctree_toggle_expansion_recursive ( widget, node )
      end

   select_node ( node : POINTER ) is
      do
         gtk_ctree_select ( widget, node )
      end

   select_recursive ( node : POINTER ) is
      do
         gtk_ctree_select_recursive ( widget, node )
      end

   unselect ( node : POINTER ) is
      do
         gtk_ctree_unselect ( widget, node )
      end

   unselect_recursive ( node : POINTER ) is
      do
         gtk_ctree_unselect_recursive ( widget, node )
      end

   real_select_recursive ( node : POINTER; state : INTEGER ) is
      do
         gtk_ctree_real_select_recursive ( widget, node, state )
      end

   node_set_text ( node : POINTER; column : INTEGER; text : POINTER ) is
      do
         gtk_ctree_node_set_text ( widget, node, column, text )
      end

   node_set_pixmap ( node : POINTER; column : INTEGER; pixmap : POINTER; mask : POINTER ) is
      do
         gtk_ctree_node_set_pixmap ( widget, node, column, pixmap, mask )
      end

   node_set_pixtext ( node : POINTER; column : INTEGER; text : POINTER; spacing : INTEGER; pixmap : POINTER; mask : POINTER ) is
      do
         gtk_ctree_node_set_pixtext ( widget, node, column, text, spacing, pixmap, mask )
      end

   set_node_info ( node : POINTER; text : POINTER; spacing : INTEGER; pixmap_closed : POINTER; mask_closed : POINTER; pixmap_opened : POINTER; mask_opened : POINTER; is_leaf : BOOLEAN; is_expanded : BOOLEAN ) is
      do
         gtk_ctree_set_node_info ( widget, node, text, spacing, pixmap_closed, mask_closed, pixmap_opened, mask_opened, is_leaf, is_expanded )
      end

   node_set_shift ( node : POINTER; column : INTEGER; vertical : INTEGER; horizontal : INTEGER ) is
      do
         gtk_ctree_node_set_shift ( widget, node, column, vertical, horizontal )
      end

   node_set_selectable ( node : POINTER; selectable : BOOLEAN ) is
      do
         gtk_ctree_node_set_selectable ( widget, node, selectable )
      end

   node_get_selectable ( node : POINTER ) : BOOLEAN is
      do
         Result := gtk_ctree_node_get_selectable ( widget, node )
      end

   node_get_cell_type ( node : POINTER; column : INTEGER ) : INTEGER is
      do
         Result := gtk_ctree_node_get_cell_type ( widget, node, column )
      end

   node_get_text ( node : POINTER; column : INTEGER; text : POINTER ) : INTEGER is
      do
         Result := gtk_ctree_node_get_text ( widget, node, column, text )
      end

   node_get_pixmap ( node : POINTER; column : INTEGER; pixmap : POINTER; mask : POINTER ) : INTEGER is
      do
         Result := gtk_ctree_node_get_pixmap ( widget, node, column, pixmap, mask )
      end

   node_get_pixtext ( node : POINTER; column : INTEGER; text : POINTER; spacing : POINTER; pixmap : POINTER; mask : POINTER ) : INTEGER is
      do
         Result := gtk_ctree_node_get_pixtext ( widget, node, column, text, spacing, pixmap, mask )
      end

   get_node_info ( node : POINTER; text : POINTER; spacing : POINTER; pixmap_closed : POINTER; mask_closed : POINTER; pixmap_opened : POINTER; mask_opened : POINTER; is_leaf : POINTER; is_expanded : POINTER ) : INTEGER is
      do
         Result := gtk_ctree_get_node_info ( widget, node, text, spacing, pixmap_closed, mask_closed, pixmap_opened, mask_opened, is_leaf, is_expanded )
      end

   node_set_row_style ( node : POINTER; new_style : POINTER ) is
      do
         gtk_ctree_node_set_row_style ( widget, node, new_style )
      end

   node_get_row_style ( node : POINTER ) : POINTER is
      do
         Result := gtk_ctree_node_get_row_style ( widget, node )
      end

   node_set_cell_style ( node : POINTER; column : INTEGER; new_style : POINTER ) is
      do
         gtk_ctree_node_set_cell_style ( widget, node, column, new_style )
      end

   node_get_cell_style ( node : POINTER; column : INTEGER ) : POINTER is
      do
         Result := gtk_ctree_node_get_cell_style ( widget, node, column )
      end

   node_set_foreground ( node : POINTER; color : POINTER ) is
      do
         gtk_ctree_node_set_foreground ( widget, node, color )
      end

   node_set_background ( node : POINTER; color : POINTER ) is
      do
         gtk_ctree_node_set_background ( widget, node, color )
      end

   node_set_row_data ( node : POINTER; data : POINTER ) is
      do
         gtk_ctree_node_set_row_data ( widget, node, data )
      end

--    node_set_row_data_full ( node : POINTER; data : POINTER; destroy : POINTER ) is
--       do
--          gtk_ctree_node_set_row_data_full ( widget, node, data, destroy )
--       end

   node_get_row_data ( node : POINTER ): POINTER is
      do
         Result := gtk_ctree_node_get_row_data ( widget, node )
      end

   node_moveto ( node : POINTER; column : INTEGER; row_align : REAL; col_align : REAL ) is
      do
         gtk_ctree_node_moveto ( widget, node, column, row_align, col_align )
      end

   node_is_visible ( node : POINTER ) : INTEGER is
      do
         Result := gtk_ctree_node_is_visible ( widget, node )
      end

   set_indent ( indent : INTEGER ) is
      do
         gtk_ctree_set_indent ( widget, indent )
      end

   set_spacing ( spacing : INTEGER ) is
      do
         gtk_ctree_set_spacing ( widget, spacing )
      end

   set_show_stub ( show_stub : BOOLEAN ) is
      do
         gtk_ctree_set_show_stub ( widget, show_stub )
      end

   set_line_style ( line_style : INTEGER ) is
      do
         gtk_ctree_set_line_style ( widget, line_style )
      end

   set_expander_style ( expander_style : INTEGER ) is
      do
         gtk_ctree_set_expander_style ( widget, expander_style )
      end

--    set_drag_compare_func ( cmp_func : POINTER ) is
--       do
--          gtk_ctree_set_drag_compare_func ( widget, cmp_func )
--       end

   sort_node ( node : POINTER ) is
      do
         gtk_ctree_sort_node ( widget, node )
      end

   sort_recursive ( node : POINTER ) is
      do
         gtk_ctree_sort_recursive ( widget, node )
      end
   
end -- GTK_CTREE
