indexing
	description: "Wrapper for %"the stream editor%", sed"
	status: "See notice at end of class"
	author: "Sam O'Connor"
	date: "$Date: 1999/10/31 10:36:47 $"
	revision: "$Revision: 1.1.1.1 $"

class

	STRING_EDITOR

inherit 

	TMP_FILE_NAMER

	EXECUTION_ENVIRONMENT

creation

	make

feature -- Initialization

	make is
			-- Initialize temporary input and output files
		do
			create in_file.make (tmp_file_name)
			create out_file.make (tmp_file_name)
		end

feature -- Access

	set_expression (expr: STRING) is
			-- Create `sed_command' using `expr'
		do
			sed_command := "sed -e '"
			sed_command.append (expr)
			sed_command.append ("' < ")
			sed_command.append (in_file.name)
			sed_command.append (" > ")
			sed_command.append (out_file.name)
			sed_command.append (" 2> /dev/null")
		end

feature -- Basic operations

	run (input: STRING): STRING is
			-- Execute `sed_command' on `input'
			-- Return output
		require
			sed_command_set: sed_command /= Void
		do
			in_file.open_write
			in_file.put_string (input)
			in_file.close
			system (sed_command)
			check
				sed_return_success: return_code = 0
			end
			in_file.delete

			out_file.open_read
			out_file.read_stream (out_file.count)
			create Result.make (0)
			Result.copy (out_file.last_string)
			out_file.close
			out_file.delete
		ensure
			result_not_void: Result /= Void
		end	

feature -- Implementation

	sed_command: STRING

	in_file: RAW_FILE

	out_file: RAW_FILE	

invariant
	
	valid_in_file: in_file /= Void
	valid_out_file: out_file /= Void

end -- class STRING_EDITOR


--!-----------------------------------------------------------------------------
--! The GOTE converter. It converts GTK+ Objects To Eiffel.
--! Copyright (C) 1999 Sam O'Connor
--!
--! This program is free software; you can redistribute it and/or modify
--! it under the terms of the GNU General Public License as published by
--! the Free Software Foundation; either version 2 of the License, or
--! (at your option) any later version.
--!
--! This program is distributed in the hope that it will be useful,
--! but WITHOUT ANY WARRANTY; without even the implied warranty of
--! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--! GNU General Public License for more details.
--!
--! You should have received a copy of the GNU General Public License
--! along with this program; if not, write to the Free Software
--! Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--!
--! See file "licence" for more information.
--!-----------------------------------------------------------------------------
