#!/usr/bin/perl -w
#===============================================================================
# gen_gtk_class_defs.pl
#-------------------------------------------------------------------------------
# Takes path to gtk source
# Produces one line per class in the form:
# class_name:parent_class_name:signal_name1 signal_name2 signal_name3 ...
#-------------------------------------------------------------------------------
# Copyright Sam O'Connor 1999, Sam@OConnor.net, see notice at end of file
#-------------------------------------------------------------------------------
# $Id: gen_gtk_class_defs.pl,v 1.1.1.1 1999/10/31 10:36:49 sam Exp $
#===============================================================================

#===============================================================================
# score
#-------------------------------------------------------------------------------
# SomthingLikeThis becomes somthing_like_this
#===============================================================================

sub score {
	$_[0] =~ s/([a-z])([A-Z])/$1_$2/g;
	$_[0] =~ y/A-Z/a-z/;
}


#===============================================================================
# Start of execution
#===============================================================================

# Did we get the GTK+ source path on the command line?
if ($#ARGV != 0) {
	print ("usage: gen_gtk_class_defs.pl path_to_gtk_source\n");
	exit 1
}
$dir = $ARGV[0];

# Get a list of GTK+ header files.
@hfiles = <$dir/gtk*.h>;
if (@hfiles == 0) {
	# Oops, where are the files? Try this:
	@hfiles = <$dir/gtk/gtk*.h>;
	if (@hfiles == 0) {
		# Nope can't find them.
		print ("$dir? Sorry, I can't see the GTK+ source there.\n");
		exit 1
	}
}

# Look at each file.
foreach (@hfiles) {
	$file = $_;
	open (HFILE, $file);
	$/ = ";";
	# Try to find the class name and parent class name
	$class = "";
	$parent = "";
	@signals = ();
	while (<HFILE>) {
		# Look for "struct _FooBarClass {"
		if (/struct[ 	]+_([A-Za-z]+)Class[ 	\n]+{/) {
			$class = $1;
#			score ($class);
			# Look for "OtherClass parent_class"
			if (/([A-Za-z]+)Class[ 	]+parent_class/) {
				$parent = $1;
#				score ($parent);
			}
		}
	}
	# Did we find a class?
	if (!($class eq "")) {
		# Does is have a .c file?
		$cfile = $file;
		$cfile =~ s/\.h/\.c/;
		if (-r $cfile) {
			open (CFILE, $cfile);
			$/ = ";";
			# Try to find signal names.
			while (<CFILE>) {
				if (/[_a-z]+_signals\[([_A-Z]+)\][ 	]*=/) {
					$signal = $1;
					if (!($signal eq "LAST_SIGNAL" 
					   || $signal eq "SIGNAL_LAST")) {
						$signal =~ y/A-Z/a-z/;
						@signals = (@signals, $signal);
					}
				}
			}
		}
		# Do da dump!
		@path = split(/\//, $file);
		$file = $path[$#path];
		print ("$file:$class:$parent:@signals\n");
	}
}

#===============================================================================
# End of file
#===============================================================================

#===============================================================================
# CVS log
#===============================================================================
#
# $Log: gen_gtk_class_defs.pl,v $
# Revision 1.1.1.1  1999/10/31 10:36:49  sam
# initial import
#
#
#===============================================================================
# End of CVS log
#===============================================================================

#===============================================================================
# The GOTE converter. It converts GTK+ Objects To Eiffel.
# Copyright (C) 1999 Sam O'Connor
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# See file "licence" for more information.
#===============================================================================
