indexing
	description: "List of C typedefs"
	status: "See notice at end of class"
	author: "Sam O'Connor"
	date: "$Date: 1999/10/31 10:36:45 $"
	revision: "$Revision: 1.1.1.1 $"

class

	C_TYPEDEFS

inherit

	LINKED_LIST [C_TYPEDEF]
		rename
			make as linked_list_make
		end

creation

	make

feature -- Initialization

	make is
		local
			t: C_TYPEDEF
		do
			linked_list_make

			create t.make ("int",      0, "INTEGER"); extend (t)
			create t.make ("short",    0, "INTEGER"); extend (t)
			create t.make ("long",     0, "INTEGER"); extend (t)
			create t.make ("float",    0, "REAL"   ); extend (t)
			create t.make ("double",   0, "DOUBLE" ); extend (t)
			create t.make ("gboolean", 0, "BOOLEAN"); extend (t)
		end

feature -- Conversion

	get_typedef (type_name: STRING): C_TYPEDEF is
			-- Find a named type 
		local
			found: BOOLEAN
		do
			from start until after or found loop
				if type_name.is_equal (item.name) then
					found := True
					Result := item
				end
				forth
			end
			if Result = Void then
				!!Result.make (type_name, 0, type_name)
			end
		ensure 
			result_valid: Result /= Void
		end

	resolve is
			-- Recursivily find and set all real base types
		do
			from start until after loop
				resolve_typedef (item)
				forth
			end
		end

	resolve_typedef (typedef: C_TYPEDEF) is
			-- Recursivily find and set real base type
		require
			valid_typedef: typedef /= Void
		local
			found: BOOLEAN
			old_index: INTEGER
		do
			old_index := index

			from start until after or found loop
				if typedef.base.is_equal (item.name) then
					found := True
					typedef.set_base (item.base)
					typedef.add_indir (item.indir)
					resolve_typedef (typedef)
				end
				forth
			end
			go_i_th (old_index)
		end

end -- class C_TYPEDEFS


--!-----------------------------------------------------------------------------
--! The GOTE converter. It converts GTK+ Objects To Eiffel.
--! Copyright (C) 1999 Sam O'Connor
--!
--! This program is free software; you can redistribute it and/or modify
--! it under the terms of the GNU General Public License as published by
--! the Free Software Foundation; either version 2 of the License, or
--! (at your option) any later version.
--!
--! This program is distributed in the hope that it will be useful,
--! but WITHOUT ANY WARRANTY; without even the implied warranty of
--! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--! GNU General Public License for more details.
--!
--! You should have received a copy of the GNU General Public License
--! along with this program; if not, write to the Free Software
--! Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--!
--! See file "licence" for more information.
--!-----------------------------------------------------------------------------
