%{

indexing
	description: "Parse prototypes from a C header file"
	status: "See notice at end of class"
	author: "Sam O'Connor"
	date: "$Date: 1999/10/31 10:36:43 $"
	revision: "$Revision: 1.1.1.1 $"

class C_PROTOTYPE_PARSER

inherit

	YY_PARSER_SKELETON [ANY]
		rename
			make as yy_parser_skeleton_make
		redefine
			report_error
		end

	C_PROTOTYPE_SCANNER
		rename
			make_with_file as c_prototype_scanner_make_with_file
		end

creation

	make_with_file

%}

%token TOK_ID
%token TOK_NOARGS
%token TOK_INDIR
%token TOK_ARRAY
%token TOK_LPAREN
%token TOK_RPAREN
%token TOK_COMMA


%%

input:     -- empty
           | input prototype {
               prototype ?= $2
               if not prototype_names.has (prototype.name) then
                       prototype_names.extend (True, prototype.name)
                       parsed_prototypes.extend (prototype)
                       prototype.set_full_text (full_text)
                       prototype.set_file_name (file_name)
                       ticker.tick
                else
                       io.put_new_line
                       io.put_string ("warning: repeated C prototype name ")
                       io.put_string (prototype.name)
                       io.put_string (" ignored")
                       io.put_new_line
                end
           };

prototype: arg TOK_LPAREN args TOK_RPAREN {
               argument ?= $1
               arguments ?= $3
               !!prototype.make_with_arguments (argument, arguments)
               $$ := prototype
           }
           | arg TOK_NOARGS {
               argument ?= $1
               !!prototype.make (argument)
               $$ := prototype
           };

args:      arg {
               argument ?= $1
               !!arguments.make
                       -- Prepend a_ to argument names, this is a kludge to avoid
                       -- argument names that clash with feature names or reserved
                       -- words. This is ok because we dont realy care what the
                       -- agument name is as long as the user can figure out what
                       -- it is for.
               argument.name.prepend ("a_")
               arguments.extend (argument)
               $$ := arguments
           }
           | args TOK_COMMA arg {
               argument ?= $3
               arguments ?= $1
                       -- kludge see comment above
               argument.name.prepend ("a_")
               arguments.extend (argument)
               $$ := arguments
           };

arg:       type TOK_ID {
               name ?= $2
               type ?= $1
               !!argument.make_with_type (name, type)
               $$ := argument
           }
           | type TOK_INDIR TOK_ID {
               name ?= $3
               type ?= $1
               indir ?= $2 
               !!argument.make_with_type_and_indir (name, type, indir.count)
               $$ := argument
           }
           | type TOK_INDIR TOK_ID TOK_ARRAY {
               name ?= $3
               type ?= $1
               indir ?= $2 
               !!argument.make_with_type_and_indir (name, type, indir.count + 1)
               $$ := argument
           }
           | type TOK_ID TOK_ARRAY {
               name ?= $2
               type ?= $1
               !!argument.make_with_type_and_indir (name, type, 1)
               $$ := argument
           };

type:      type TOK_ID {
               $$ := $2
           }
           | TOK_ID {
               $$ := $1
           };

%%

feature -- Initialization

	make_with_file (file: IO_MEDIUM; t: TICKER)  is
			-- Initialize scanner with file
			-- Initialize parser
			-- Initialize `parsed_prototypes'
		require
			file_open_for_read: file.is_open_read
		do
			!!prototype_names.make (0)
			c_prototype_scanner_make_with_file (file)
			yy_parser_skeleton_make
			ticker := t
		end

feature -- Implementation

	report_error (a_message: STRING) is
		do
			io.put_string("C_PROTOTYPE_PARSER ")
			io.put_string(a_message)
			io.put_new_line
			io.put_string("last_value ")
			io.put_string(last_value)
			io.put_new_line
			io.put_string("full_text ")
			io.put_string(full_text)
			io.put_new_line
			io.put_string("name ")
			io.put_string(name)
			io.put_new_line
			io.put_string("type ")
			io.put_string(type)
			io.put_new_line
			io.put_string("indir ")
			io.put_string(indir)
			io.put_new_line
		end

	name, type, indir: STRING

	argument: C_ARGUMENT

	arguments: C_ARGUMENTS

	prototype: C_PROTOTYPE

	parsed_prototypes: C_PROTOTYPES

	prototype_names: HASH_TABLE [BOOLEAN, STRING]

	ticker: TICKER

end


--!-----------------------------------------------------------------------------
--! The GOTE converter. It converts GTK+ Objects To Eiffel.
--! Copyright (C) 1999 Sam O'Connor
--!
--! This program is free software; you can redistribute it and/or modify
--! it under the terms of the GNU General Public License as published by
--! the Free Software Foundation; either version 2 of the License, or
--! (at your option) any later version.
--!
--! This program is distributed in the hope that it will be useful,
--! but WITHOUT ANY WARRANTY; without even the implied warranty of
--! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--! GNU General Public License for more details.
--!
--! You should have received a copy of the GNU General Public License
--! along with this program; if not, write to the Free Software
--! Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--!
--! See file "licence" for more information.
--!-----------------------------------------------------------------------------
