%{

indexing
	description: "Scan for enum names in a C header file"
	author: "Sam O'Connor"
	status: "see notice at end of class"
	date: "$Date: 1999/10/31 10:36:41 $"
	revision: "$Revision: 1.1.1.1 $"

class
	C_ENUM_SCANNER

inherit
	YY_COMPRESSED_SCANNER_SKELETON

creation
	make_with_file

%}

WS     [ \r\f\v\t\n]
ID     [a-zA-Z][_a-zA-Z0-9]*
ENUMEL {ID}({WS}*"="{WS}*[^,}]+)?
ENUM   enum({WS}+{ID})?{WS}*"{"{WS}*{ENUMEL}({WS}*","{WS}*{ENUMEL})*{WS}*"}"
ASSIGN "="{WS}*[^,}]+

%x SC_ENUM
%x SC_ENUMLIST

%%

{ENUM}                { set_start_condition (SC_ENUM); less (0) }
<SC_ENUM>[^{]           -- chew leftovers
<SC_ENUM>"{"          { set_start_condition (SC_ENUMLIST)       } 
<SC_ENUMLIST>{ID}     { last_token := 1                         }
<SC_ENUMLIST>{ASSIGN}   -- chew assignments
<SC_ENUMLIST>[^}]       -- chew leftovers
<SC_ENUMLIST>"}"      { set_start_condition (INITIAL)           } 
[^e]*                   -- chew leftovers
e                       -- chew leftovers

%%

end


--!-----------------------------------------------------------------------------
--! The GOTE converter. It converts GTK+ Objects To Eiffel.
--! Copyright (C) 1999 Sam O'Connor
--!
--! This program is free software; you can redistribute it and/or modify
--! it under the terms of the GNU General Public License as published by
--! the Free Software Foundation; either version 2 of the License, or
--! (at your option) any later version.
--!
--! This program is distributed in the hope that it will be useful,
--! but WITHOUT ANY WARRANTY; without even the implied warranty of
--! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--! GNU General Public License for more details.
--!
--! You should have received a copy of the GNU General Public License
--! along with this program; if not, write to the Free Software
--! Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--!
--! See file "licence" for more information.
--!-----------------------------------------------------------------------------
