-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkPreview objects"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"

class GTK_PREVIEW_WRITER

inherit

	GTK_ATTRIBUTE_WRITER
		rename
			make as make_attribute
		redefine
			append_parent_creation, parent_inherit
		end

	CHILD

creation

	make

feature

		
	type: STRING is "GTK_PREVIEW"

	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		do
			make_attribute(attr_name, tree, src)
			-- The following tag should probably be called colour
			preview_type := widget_tree.get_boolean_from_field("type", True)
			expand := widget_tree.get_boolean_string_from_field("expand")
		end
			
	preview_type: BOOLEAN
	expand: STRING
	
	append_parent_creation(code: ARRAY[STRING]) is
		local
			gtk_preview_type: STRING
		do
			if preview_type then
				gtk_preview_type := "Gtk_preview_color"
			else
				gtk_preview_type := "Gtk_preview_grayscale"
			end
			code.add_last("!!" + name + ".make("+gtk_preview_type+")")
			code.add_last(name + ".set_expand(" + expand +")")
			add_widget_code(code)
		end

	parent_inherit: INHERIT_LIST is
		local
			temp: KLASS
		do
			!!Result.make
			!!temp.make_with_name("GTK_PREVIEW_EXTERNALS")
			temp.add_undefine_clause("copy, is_equal")
			Result.add(temp)
		end
			
end
