-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkMenuBar objects"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"

class GTK_MENU_ITEM_WRITER

inherit

	GTK_BIN_WRITER
		rename
			make as make_attribute
		redefine
			append_parent_creation
		end
	
creation

	make

feature

		
	type: STRING is
		do
			Result := "GTK_MENU_ITEM"
		end

	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		local
			submenu: TAG_TREE
		do
			make_attribute(attr_name, tree, src)
			label := tree.get_string_from_field("label")
			right_justify := tree.get_boolean_from_field("right_justify", False)
			submenu := tree.find_child("widget")
			if submenu /= Void then
				create_child_class(submenu)
			end
		end

	label: STRING
	right_justify: BOOLEAN

	add_common_menu_item_code(code: ARRAY[STRING]) is
		local
			i: INTEGER
			temp_child: CHILD
		do
			if right_justify then
				code.add_last(name + ".right_justify")
			end
			add_widget_code(code)
			if last_class /= Void then
				last_class.append_parent_creation(code)
				temp_child ?= last_class
				code.add_last(name + ".set_submenu(" + last_class.name + ")")
			end
		end

	append_parent_creation(code: ARRAY[STRING]) is
		do
			if label.empty then
				code.add_last("!!" + name + ".make")
			else
				code.add_last("!!" + name + ".make_with_label(%""+label+"%")")
			end
			add_common_menu_item_code(code)
		end

end
