(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                  dpc.ml                                  *)
(****************************************************************************)

open Pp;;

open Std;;
open Proof_trees;;
open Tacmach;;

open Tactics;;

open Prove;;
open Ccidpc;;



let rec intros_forall gls = 
  let t = pf_concl gls
  in if is_forall_term t
     then ((tclTHEN (forAllI) (intros_forall))) gls
     else tclIDTAC gls;;

let dPC_nq gls =
    let f = dpc_of_cci_fmla gls (pf_concl gls) in
    try let pf = prove_f f in 
      	tradpf [] [] pf gls
    with Not_provable_in_DPC s -> errorlabstrm "dpc__DPC_nq"
            [< 'sTR"Not provable in Direct Predicate Calculus" >]
 
       | No_intuitionnistic_proof n  -> errorlabstrm "dpc__DPC_nq"
            [< 'sTR ("Found "^(string_of_int n)^" classical proof(s) but"
		                             ^" no intuitionnistic one !") >]
;;

let dPC =
  ((tclTHEN (intros_forall) (dPC_nq))) 
;;

let dPC_l lcom =
  ((tclTHEN (intros_forall) (( (tclTHEN ((tactic_com_list generalize lcom)) (dPC))))) )
;;

let dPC_tac = hide_atomic_tactic "DPC" dPC;;

let dPC_l_tac = hide_tactic "DPC_l" 
    (fun l -> let lcom = List.map (fun (COMMAND c) -> c) l
              in dPC_l lcom)
;;


(* $Id: dpc.ml,v 1.9 1999/06/29 07:48:09 loiseleu Exp $ *)
