(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                himsg.mli                                 *)
(****************************************************************************)

open Pp
open Names
open Term

val pFTERM      : constr -> std_ppcmds
val pTERM       : constr -> std_ppcmds
val pENV        : std_ppcmds -> environment -> std_ppcmds
val pTERMINENV  : 'a assumptions * constr -> std_ppcmds
val pFTERMINENV : 'a assumptions * constr -> std_ppcmds
val pFTYPEINENV : 'a assumptions * type_judgement -> std_ppcmds
val pID         : identifier -> std_ppcmds

(* adding a header and a trailer to a UserError msg *)

val wrap_error : CoqAst.loc * string * std_ppcmds * exn * std_ppcmds -> 'a

(* conversion ast -> term errors *)
val error_var_not_found : string -> identifier -> 'a
val error_fixname_unbound : string -> bool -> string -> 'a
val error_sosub_execute : path_kind -> CoqAst.t -> 'a

(* type errors *)
val error_cant_execute   : path_kind -> 'b assumptions -> constr -> 'a
val error_unbound_rel    : path_kind -> environment -> int -> 'a
val error_not_type       : path_kind -> environment -> constr -> 'a
val error_assumption     : path_kind -> environment -> constr -> 'a
val error_generalization :
  path_kind -> environment -> name * type_judgement -> judgement -> 'a
val error_cant_apply     : string -> path_kind ->
  environment -> judgement -> judgement list -> 'a
val error_actual_type    :
  path_kind -> environment -> judgement -> judgement -> 'a
val error_ise_resolve    : path_kind -> constr -> std_ppcmds -> 'a

val error_not_inductive       : path_kind -> constr -> 'a
val error_case_not_inductive  : path_kind ->
  'b assumptions -> constr -> constr -> 'a
val error_elim_arity          : path_kind -> 'b assumptions -> constr ->
  constr list -> constr -> constr -> constr ->
    (constr * constr * string) option -> 'a
val error_number_branches     : path_kind ->
  'b assumptions -> constr -> constr -> int -> 'a
val error_ill_formed_branch   :
  path_kind -> 'b assumptions -> constr -> int -> constr -> constr -> 'a
val error_ill_formed_inductive : path_kind ->
  name list -> constr -> constr -> 'a
val error_bad_ind_parameters : path_kind ->
  name list -> constr -> int -> constr -> constr -> 'a
val error_non_strictly_positive : path_kind ->
  name list -> constr -> constr -> 'a
val error_ill_formed_constructor : path_kind ->
  name list -> constr -> constr -> 'a
val error_ml_case :
  string -> environment -> constr -> constr -> constr -> constr -> 'a
val error_ill_formed_rec_body :
  std_ppcmds -> path_kind -> name list -> int -> constr array -> 'a
val error_ill_typed_rec_body  :
  path_kind -> int -> name list -> judgement array -> type_judgement array -> 'a

(* unification errors *)
val error_cannot_unify : path_kind -> constr * constr -> 'a

(* $Id: himsg.mli,v 1.13 1999/09/08 12:34:43 herbelin Exp $ *)
