(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                macros.ml                                 *)
(****************************************************************************)

open Names
open Tacmach
open Proof_trees

type macro_data =
    {mac_args : string list;
     mac_body : Ast.act}

val add_macro_hint : string -> string list * Ast.act -> unit
val lookup         : string -> macro_data 
val macro_expand   : CoqAst.loc -> string -> tactic_arg list -> CoqAst.t

(* $Id: macros.mli,v 1.4 1999/06/29 07:47:34 loiseleu Exp $ *)
