(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                clexer.mli                                *)
(****************************************************************************)

module CharMap : Map.S with type key = char
type ttree = { node: string option; branch: ttree CharMap.t }
val empty_ttree : ttree
val ttree_add : ttree -> string -> ttree
val ttree_find : ttree -> string -> string

exception BadToken of string

val check_special_token : string -> unit
val check_ident : string -> unit

val add_special_token : string -> unit
val find_keyword : string -> string
val add_keyword : string -> unit
val add_token : string * string -> unit

type frozen_t
val freeze : unit -> frozen_t
val unfreeze : frozen_t -> unit
val init : unit -> unit

val next_token : char Stream.t -> Token.t * (int * int)

val func : char Stream.t -> Token.t Stream.t * (int -> int * int)
val token_text : Token.pattern -> string
val tparse : Token.pattern -> Token.t Stream.t -> string
