(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                system.mli                                *)
(****************************************************************************)

open Pp

val getcwd: unit -> string

val home: string

val slash: string -> string list -> string

val add_path : string -> unit
val del_path : string -> unit
val alldir : string -> string list
val radd_path : string -> unit
val search_paths : unit -> string list

val safe_getenv : string -> string
val safe_getlogin : unit -> string
val glob : string -> string

val make_suffix: string -> string -> string

val open_trapping_failure : (string -> 'a) -> string -> string -> 'a
val find_file_in_path : string list -> string -> string
val file_readable_p : string -> bool
val open_in_maybe_compressed : string -> in_channel

(*For LoadPath or MLPath*)
val is_in_path:string list->string->bool;;
val where_in_path:string list->string->string;;

val round_reset : unit -> unit
val round_step : unit -> unit
val round_end : unit -> unit

val all_vo_in_path : unit -> string list

val extern_intern : int * string -> (string -> 'a -> unit) * (string -> 'a)

type process_times
val timestamp : unit -> float * process_times
val process_time : unit -> float * float

val fmt_time_difference : 
                   float * process_times -> float * process_times -> std_ppcmds

(* $Id: system.mli,v 1.17 1999/07/19 10:49:49 herbelin Exp $ *)
