(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                pfedit.mli                                *)
(****************************************************************************)

open Names
open Term
open Pp
open Proof_trees
open Tacmach
open Constrtypes
open States

type proof_topstate = 
    {top_hyps : context * context;
     top_goal : goal;
     top_strength : strength }

val undo_limit : int ref
val set_undo : int -> unit

val msg_proofs : bool -> std_ppcmds
val unset_undo : unit -> unit

val get_state : unit -> pftreestate * proof_topstate
val get_topstate : unit -> proof_topstate
val get_pftreestate : unit -> pftreestate
val get_evmap_sign : int option -> evar_declarations * context
val set_proof : string option -> unit
val get_proof : unit -> string
val list_proofs : unit -> string list
val add_proof : string * pftreestate * proof_topstate -> unit
val del_proof : string -> unit
val init_proofs : unit -> unit

val mutate : (pftreestate -> pftreestate) -> unit
val rev_mutate : (pftreestate -> pftreestate) -> unit
val start : string * proof_topstate -> unit
val restart : unit -> unit
val proof_prompt : unit -> string
val proof_term : unit -> constr

val undo : int -> unit
val resume_last : unit -> unit

val refining : unit -> bool
val abort_goal : string -> unit
val abort_cur_goal : unit -> unit
val abort_goals : unit -> unit
val abort_refine : ('a -> 'b) -> 'a -> 'b
val reset_name : identifier -> unit
val reset_keeping_name : identifier -> unit
val save_state : string -> string -> unit
val restore_state : string -> unit
val restore_last_saved_state : unit -> unit
val reset_all : unit -> unit
val reset_section : string -> unit
val reset_prelude : unit -> unit
val reset_initial : unit -> unit

val start_proof : string -> strength -> CoqAst.t -> unit
val start_proof_constr : string -> strength -> constr -> unit

val save_named : bool -> unit
val save_anonymous : bool -> string -> 'a -> unit
val save_anonymous_thm : bool -> string -> unit
val save_anonymous_remark : bool -> string -> unit

val solve_nth : int -> tactic -> unit
val by : tactic -> unit
val traverse : int -> unit
val traverse_nth_goal : int -> unit
val traverse_to : int list -> unit

val subtree_solved : unit -> bool
(* $Id: pfedit.mli,v 1.14 1999/08/06 20:49:09 herbelin Exp $ *)
