(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                             abstraction.mli                              *)
(****************************************************************************)

open Names;;
open Term;;
open Libobject;;
open Generic;;
open More_util;;

type abstraction_object = 
  { abs_kind : path_kind
  ; abs_arity : int array
  ; abs_rhs : constr
  }
;;
val cache_abstraction : section_path * abstraction_object -> unit;;
val specification_abstraction : 'a -> 'a;;
val outAbstraction : obj -> abstraction_object;;
val inAbstraction : abstraction_object -> obj;;
val abst_of_path : section_path -> section_path * abstraction_object;;
val abst_option_of_path : section_path -> (section_path * abstraction_object) option;;
val count_dlam : 'a term -> int;;
val execute_abstraction : path_kind -> int array -> sorts oper term -> abstraction_object;;
val is_abstraction : section_path -> bool;;
val contract_abstraction : sorts oper term -> constr;;
val make_abstraction : section_path -> 'a oper term array -> 'a oper term;;

(* $Id: abstraction.mli,v 1.6 1999/06/29 07:46:58 loiseleu Exp $ *)
