/*
 * Time-stamp: <98/11/03 14:39:36 panic>
 * Author:	The C-Mix Project <cmix@diku.dk>
 *              Arne John Glenstrup  <panic@diku.dk>
 * Contents:	Functions for showing the image using the PTC API
 *		from http://www.gaffer.org/ptc
 */

#include "ptc/ptc.h"
#include <stdio.h>

// create format
static Format format(32,0x00FF0000,0x0000FF00,0x000000FF);
static Console console;
static Surface* surface;
static int32 *pixels;
static int windowHeight, windowWidth;
static int use_color;

typedef unsigned char uint8;

extern "C" void initWindow(char *title, int height, int width, int use_c) {
  windowWidth = width; windowHeight = height; use_color = use_c;
  try
    {
      // create console
      console.open(title, width, height, format);
      // create surface
      surface = new Surface(width, height, format);
      // lock surface
      pixels = (int32*) surface->lock();
    }
    catch (Error &error)
    {
        // report error
        error.report();
    }
}

extern "C" void closeWindow() { }

static void plotColor(int x, int y, double red, double green, double blue) {
  uint8 r, g, b;
  r = (uint8)(red * 256.0);
  g = (uint8)(green * 256.0);
  b = (uint8)(blue * 256.0);
  // draw color [r,g,b] at position [x,y]
  pixels[x + (windowHeight - 1 - y) * windowWidth] = (r << 16) + (g << 8) + b;
}

static void plotGrey(int x, int y, double red, double green, double blue) {
  uint8 r, g, b;
  double intensity;
  intensity = (red + green + blue) / 3;
  r = (uint8)(intensity * 256.0);
  g = (uint8)(intensity * 256.0);
  b = (uint8)(intensity * 256.0);
  // draw color [r,g,b] at position [x,y]
  pixels[x + (windowHeight - 1 - y) * windowWidth] = (r << 16) + (g << 8) + b;
}

extern "C" void plot(int x, int y, double red, double green, double blue) {
  if (use_color)
    plotColor(x, y, red, green, blue);
  else
    plotGrey(x, y, red, green, blue);
}

extern "C" void refreshLine (int y) {
  // unlock surface
  surface->unlock();
  
  // copy surface to console area
  surface->copy(console,
		Area(0, windowHeight - y - 1, windowWidth, windowHeight - y),
		Area(0, windowHeight - y - 1, windowWidth, windowHeight - y));
  // update console (Area update is not meant as a partial update!!)
  // Use a partial copy for that. Area update is only there to speed
  // up windowed display and does NOT have an effect in DGA mode.
  console.update(Area(0, windowHeight - y - 1, windowWidth, windowHeight - y));
  //console->update();
  pixels = (int32*) surface->lock();
}

extern "C" int waitKeyOrClick() {
  int ch;
  // loop until a key is pressed
  while (!(ch = console.key()))
    console.update(Area(0, 0, windowWidth, windowHeight));
  console.read();
  return ch;
}
