(* camlp4r *)
(***********************************************************************)
(*                                                                     *)
(*                             Camlp4                                  *)
(*                                                                     *)
(*        Daniel de Rauglaudre, projet Cristal, INRIA Rocquencourt     *)
(*                                                                     *)
(*  Copyright 1998 Institut National de Recherche en Informatique et   *)
(*  Automatique.  Distributed only by permission.                      *)
(*                                                                     *)
(***********************************************************************)

(* Id *)

let interf ast =
  let pt = Ast2pt.interf (List.map fst ast) in
  let oc =
    match !(Pcaml.output_file) with
      Some f -> open_out_bin f
    | None -> stdout
  in
  output_string oc Oconfig.ast_intf_magic_number;
  output_value oc !(Pcaml.input_file);
  output_value oc pt;
  flush oc;
  begin match !(Pcaml.output_file) with
    Some _ -> close_out oc
  | None -> ()
  end;
  ()
;;

let implem ast =
  let pt = Ast2pt.implem (List.map fst ast) in
  let oc =
    match !(Pcaml.output_file) with
      Some f -> open_out_bin f
    | None -> stdout
  in
  output_string oc Oconfig.ast_impl_magic_number;
  output_value oc !(Pcaml.input_file);
  output_value oc pt;
  flush oc;
  begin match !(Pcaml.output_file) with
    Some _ -> close_out oc
  | None -> ()
  end;
  ()
;;

Pcaml.print_interf := interf;;
Pcaml.print_implem := implem;;
