(* camlp4r *)
(***********************************************************************)
(*                                                                     *)
(*                             Camlp4                                  *)
(*                                                                     *)
(*        Daniel de Rauglaudre, projet Cristal, INRIA Rocquencourt     *)
(*                                                                     *)
(*  Copyright 1998 Institut National de Recherche en Informatique et   *)
(*  Automatique.  Distributed only by permission.                      *)
(*                                                                     *)
(***********************************************************************)

(* $Id: pr_dump.ml,v 2.1 1999/11/23 21:05:04 ddr Exp $ *)

value interf ast =
  let pt = Ast2pt.interf (List.map fst ast) in
  let oc =
    match Pcaml.output_file.val with
    [ Some f -> open_out_bin f
    | None -> stdout ]
  in
  do output_string oc Oconfig.ast_intf_magic_number;
     output_value oc Pcaml.input_file.val;
     output_value oc pt;
     flush oc;
     match Pcaml.output_file.val with
     [ Some _ -> close_out oc
     | None -> () ];
  return ()
;

value implem ast =
  let pt = Ast2pt.implem (List.map fst ast) in
  let oc =
    match Pcaml.output_file.val with
    [ Some f -> open_out_bin f
    | None -> stdout ]
  in
  do output_string oc Oconfig.ast_impl_magic_number;
     output_value oc Pcaml.input_file.val;
     output_value oc pt;
     flush oc;
     match Pcaml.output_file.val with
     [ Some _ -> close_out oc
     | None -> () ];
  return ()
;

Pcaml.print_interf.val := interf;
Pcaml.print_implem.val := implem;
