/* ---------------------------------------------------------------------
 *
 * -- Automatically Tuned Linear Algebra Software (ATLAS)
 *    (C) Copyright 1999 All Rights Reserved
 *
 * -- ATLAS routine -- Version 2.0 -- December 25, 1999
 *
 * -- Suggestions,  comments,  bugs reports should be sent to the follo-
 *    wing e-mail address: atlas@cs.utk.edu
 *
 *  Author         : Antoine P. Petitet
 * University of Tennessee - Innovative Computing Laboratory
 * Knoxville TN, 37996-1301, USA.
 *
 * ---------------------------------------------------------------------
 *
 * -- Copyright notice and Licensing terms:
 *
 * Redistribution  and  use in  source and binary forms, with or without
 * modification, are  permitted provided  that the following  conditions
 * are met:
 *
 * 1) Redistributions  of  source  code  must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2) Redistributions in binary form must reproduce  the above copyright
 *    notice,  this list of  conditions and the  following disclaimer in
 *    the documentation and/or other materials provided with the distri-
 *    bution.
 * 3) All advertising materials mentioning features or use of this soft-
 *    ware must display the folowing acknowledgement:
 *    This product includes software developed by the ATLAS group of the
 *    University of Tennesee, Knoxville and its contributors.
 * 4) The names of the  University of Tennessee,  Knoxville,  the  ATLAS
 *    group, or the names of its contributors may not be used to endorse
 *    or  promote products derived  from  this software without specific
 *    prior written permission.
 *
 * -- Disclaimer:
 *
 * The University of Tennessee, Knoxville,  the ATLAS group,  or the au-
 * thors make  no representations about the suitability of this software
 * for any purpose.  This software is provided ``as is'' without express
 * or implied warranty.
 *
 * ---------------------------------------------------------------------
 */
/*
 * Include files
 */
#include "atlas_refmisc.h"
#include "atlas_reflevel1.h"

int ATL_idrefamax
(
   const int                  N,
   const double               * X,
   const int                  INCX
)
{
/*
 * Purpose
 * =======
 *
 * ATL_idrefamax  returns the index in an n-vector x of the first element
 * having maximum absolute value.
 *
 * Arguments
 * =========
 *
 * N       (input)                       const int
 *         On entry, N specifies the length of the vector x. N  must  be
 *         at least zero. Unchanged on exit.
 *
 * X       (input)                       const double *
 *         On entry,  X  points to the  first entry to be accessed of an
 *         incremented array of size equal to or greater than
 *            ( 1 + ( n - 1 ) * abs( INCX ) ) * sizeof(   double  ),
 *         that contains the vector x. Unchanged on exit.
 *
 * INCX    (input)                       const int
 *         On entry, INCX specifies the increment for the elements of X.
 *         INCX must not be zero. Unchanged on exit.
 *
 * ---------------------------------------------------------------------
 */
/*
 * .. Local Variables ..
 */
   register int               imax = 0, i = 0, j;
   int                        nu;
   const int                  incX2 = 2 * INCX, incX3 = 3 * INCX,
                              incX4 = 4 * INCX, incX5 = 5 * INCX,
                              incX6 = 6 * INCX, incX7 = 7 * INCX,
                              incX8 = 8 * INCX;
   double                     * StX;
   register double            absxi, smax = ATL_dZERO, x0, x1, x2, x3,
                              x4, x5, x6, x7;
/* ..
 * .. Executable Statements ..
 *
 */
   if( N > 0 )
   {
      if( ( nu = ( N >> 3 ) << 3 ) != 0 )
      {
         StX = (double *)X + nu * INCX;

         do
         {
            x0 = (*X);     x4 = X[incX4]; x1 = X[INCX ]; x5 = X[incX5];
            x2 = X[incX2]; x6 = X[incX6]; x3 = X[incX3]; x7 = X[incX7];

            absxi = Mdabs( x0 );
            if( absxi > smax ) { imax = i; smax = absxi; }
            i    += 1;

            absxi = Mdabs( x1 );
            if( absxi > smax ) { imax = i; smax = absxi; }
            i    += 1;

            absxi = Mdabs( x2 );
            if( absxi > smax ) { imax = i; smax = absxi; }
            i    += 1;

            absxi = Mdabs( x3 );
            if( absxi > smax ) { imax = i; smax = absxi; }
            i    += 1;

            absxi = Mdabs( x4 );
            if( absxi > smax ) { imax = i; smax = absxi; }
            i    += 1;

            absxi = Mdabs( x5 );
            if( absxi > smax ) { imax = i; smax = absxi; }
            i    += 1;

            absxi = Mdabs( x6 );
            if( absxi > smax ) { imax = i; smax = absxi; }
            i    += 1;

            absxi = Mdabs( x7 );
            if( absxi > smax ) { imax = i; smax = absxi; }
            i    += 1;

            X    += incX8;

         } while( X != StX );
      }

      for( j = N - nu; j != 0; j-- )
      {
         x0    = (*X);
         absxi = Mdabs( x0 );
         if( absxi > smax ) { imax = i; smax = absxi; }
         i    += 1;
         X    += INCX;
      }
   }
   return( imax );
/*
 * End of ATL_idrefamax
 */
}
