
#define DREAL
#include "atlas_misc.h"
#include "atlas_level1.h"
#include "cblas.h"

void cblas_drotm(const int N, double *X, const int incX, 
                 double *Y, const int incY, const double *P)
{
   if (incX < 0)
   {
      if (incY < 0) ATL_drotm(N, X, -incX, Y, -incY, P);
      else ATL_drotm(N, X+(1-N)*incX, incX, Y, incY, P);
   }
   else if (incY < 0) ATL_drotm(N, X+(N-1)*incX, -incX, Y, -incY, P);
   else ATL_drotm(N, X, incX, Y, incY, P);
}
