
#define SCPLX
#include "atlas_misc.h"
#include "atlas_level1.h"
#include "cblas.h"

void cblas_csrot(const int N, void *X, const int incX, 
                 void *Y, const int incY, const void c, const void s)
{
   if (incX < 0)
   {
      if (incY < 0) ATL_crot(N, X, -incX, Y, -incY, c, s);
      else ATL_crot(N, X+((1-N)*incX<<1), incX, Y, incY, c, s);
   }
   else if (incY < 0) 
      ATL_crot(N, X+((N-1)*incX<<1), -incX, Y, -incY, c, s);
   else ATL_crot(N, X, incX, Y, incY, c, s);
}
