------------------------------------------------------------------------------
--                                                                          --
--                 ASIS-for-GNAT IMPLEMENTATION COMPONENTS                  --
--                                                                          --
--                         A 4 G . E X P R _ S E M                          --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--            Copyright (c) 1995-1999, Free Software Foundation, Inc.       --
--                                                                          --
-- ASIS-for-GNAT is free software; you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version. ASIS-for-GNAT is distributed  in the hope  that it will be use- --
-- ful, but WITHOUT ANY WARRANTY; without even the implied warranty of MER- --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General  --
-- Public License for more details. You should have received a copy of the  --
-- GNU General Public License  distributed with ASIS-for-GNAT; see file     --
-- COPYING. If not, write to the Free Software Foundation,  59 Temple Place --
-- - Suite 330,  Boston, MA 02111-1307, USA.                                --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- ASIS-for-GNAT was originally developed  by the ASIS-for-GNAT team at the --
-- Software  Engineering  Laboratory  of  the Swiss  Federal  Institute  of --
-- Technology (LGL-EPFL) in Lausanne,  Switzerland, in cooperation with the --
-- Scientific  Research  Computer  Center of  Moscow State University (SRCC --
-- MSU), Russia,  with funding partially provided  by grants from the Swiss --
-- National  Science  Foundation  and  the  Swiss  Academy  of  Engineering --
-- Sciences.  ASIS-for-GNAT is now maintained by  Ada Core Technologies Inc --
-- (http://www.gnat.com).                                                   --
--                                                                          --
------------------------------------------------------------------------------

--  This package contains routines needed for semantic queries from
--  the Asis.Expressions package

with Asis; use Asis;

package A4G.Expr_Sem is

   --  All the routines defined in this package do not check their
   --  arguments - a caller is responsible for the proper use of these
   --  routines

   -------------------------------------------------
   --  Routines for Corresponding_Expression_Type --
   -------------------------------------------------

   function Expr_Type (Expression : Asis.Expression) return Asis.Declaration;
   --  using the fact, that Expression is of An_Expression kind and that
   --  the Etype field is set for its Node, this function finds the
   --  type declaration which should be returned as the result of
   --  Corresponding_Expression_Type (Expression)

   -------------------------------------------------
   --  Routines for Corresponding_Name_Definition --
   -------------------------------------------------

   function Identifier_Name_Definition (Reference_I : Element)
      return Asis.Defining_Name;
--   function Operator_Symbol_Name_Definition (Reference_Op : Element)
--      return Asis.Defining_Name;
   function Character_Literal_Name_Definition (Reference_Ch : Element)
      return Asis.Defining_Name;
   --  function Enumeration_Literal_Name_Definition (Reference_En : Element)
   --    return Asis.Defining_Name;
   --  each of these four functions provides an Element representing the
   --  defining occurrence for its argument, provided that the argument is
   --  of appropriate kind and all the necessary checks have already been
   --  done
   --  Now we are trying to aggregate Enumeration_Literal_Name_Definition
   --  and Operator_Symbol_Name_Definition into Identifier_Name_Definition

end A4G.Expr_Sem;