// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: tree.h,v 1.2 1998/08/27 04:10:18 jgg Exp $
/* ######################################################################

   Tree - Tree Widget
   
   This class handles the usual Expandable tree. It also double as a
   list class (just have items with no children)
   
   ##################################################################### */
									/*}}}*/
// Header section: deity
#ifndef DEITY_TREE_H
#define DEITY_TREE_H

#ifdef __GNUG__
#pragma interface "deity/tree.h"
#endif  

#include <string>
#include <deity/basic.h>

// Notifications generated by Tree
#define Nt_SelectChange Notifyer::Tag(Tree::Type,1) // Data -> IsFlag(Wf_Set), Toggle button only

class Tree : public BasicWidget
{
   public:

   // Single list item
   class Item
   {
      friend Tree;
      protected:
      
      unsigned long Flags;
      
      // Action members
      virtual void Render(CombinedGC &GC,unsigned long Depth,Rect Pos,Tree *Owner) = 0;
      virtual bool InButton(unsigned long,long) {return false;};
      virtual long Height() = 0;
      virtual bool Expand(Tree */*Owner*/) {return true;};
      virtual void Contract(Tree *) {};
      virtual void Mouse(Tree *Owner,const MouseEvent &Event);
            
      public:

      // Tree links
      Item *Parent;
      Item *Child;
      Item *Next;      
      Item *Last;

      // Item flags
      enum Flags
      {
	 Expanded = (1 << 0),
	 Selected = (1 << 1),
	 Expandable = (1 << 2)
      };

      // Flags (From widget)
      inline bool IsFlag(unsigned long F) {return (Flags & F) == F;};
      void Flag(unsigned long State, unsigned long F) {Flags = (Flags & (~F)) | State;};
      inline void Flag(unsigned long F) {Flags |= F;};
      inline bool IsExpandable() {return IsFlag(Expandable) == true || Child != 0;};
      inline bool IsExpanded() {return IsFlag(Expanded);};
	 
      // Addition routines
      void After(Item *Previous);
      void AfterStep(Item *&Root,Item *&Previous);
      
      // Utility functions
      void DrawLines(CombinedGC &GC,long Width,unsigned long Depth,Rect Pos);
      Color SetColors(CombinedGC &GC,Tree *Owner,bool Highlight);
      Color SetColors(CombinedGC &GC,Tree *Owner,bool Highlight,Color Clr);
      void ExpandChildren(Tree *Owner);
      void ContractChildren(Tree *Owner);
      
      // These simulate the cursor keys
      Item *Down();
      Item *Up();
      
      // Lame RTTI simlulant
      virtual unsigned int Type() {return 0;};
      
      Item(Item *Parent = 0);
      virtual ~Item();
   };
   
   protected:
   Item *iRoot;
   Item *Top;
   Item *Current;

   Color iActiveColor;
   Color iActiveTextColor;

   long ItemHeight;

   // Widget event handlers
   virtual void Render(CombinedGC &GC) {QuickRedraw(GC,0,0);};
   void QuickRedraw(CombinedGC &GC,Item *A,Item *B);
   virtual bool Key(const KeyEvent &Key,Widget *Source);
   virtual void Mouse(const MouseEvent &Event);

   public:
   static void *Type;
   
   // Various manipulators
   void Root(Item *P);
   void Center(Item *Target,unsigned long Pos,bool Force = true);
   Item *ItemFromTop(unsigned long Count);
   void EraseAll();
   Item *CurrentItem() {return Current;};
   void CurrentItem(Item *Item);
   
   inline Color ActiveColor() {return iActiveColor;};
   inline Color ActiveTextColor() {return iActiveTextColor;};

   Tree(Widget *Parent = 0);
   virtual ~Tree();
};

class TreeString : public Tree::Item
{
   protected:
   virtual void Render(CombinedGC &GC,unsigned long Depth,
		       Rect Pos,Tree *Owner);
   virtual long Height();
   virtual bool InButton(unsigned long Depth,long X);

   public:

   string S;

   virtual unsigned int Type() {return 1;};
   
   TreeString(string Text,Tree::Item *Parent = 0);
};

#endif
