// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: menubar.h,v 1.2 1998/08/27 04:09:53 jgg Exp $
/* ######################################################################

   Menu Bar - Top menu bar
   Menu Popup - Floating vertical menu
   
   The Menu Bar extents itself so that it is always located at the
   top of it's owner window, and is the full length of the owner window.
   It activates the AutoExent flag to keep it's position in sync.
   
   It also controls the position of it's children so that they are
   ordered horizontaly along the menu bar. Each child should likely be a
   MenuItem type class to get the expected results, though any widget 
   could be inserted into a Menu Bar.

   The Menu Popup remains unrealized untill explicitly realized. 
   It then reparents itself to the root window and displays itself, but
   before it does that it sets the force focus bits on it's parent
   tree to keep the highlighting. This is all done so that a popup
   menu can be attached to a menu widget and have the desired results.
   
   ##################################################################### */
									/*}}}*/
// Header section: deity
#ifndef DEITY_MENUBAR_H
#define DEITY_MENUBAR_H

#ifdef __GNUG__
#pragma interface "deity/menubar.h"
#endif  

#include <deity/basic.h>

class MenuBar : public BasicWidget
{
   protected:

   Widget *LastFocus;
   
   // Draws the menu bar
   virtual bool Key(const KeyEvent &Key,Widget *Source);
   virtual void FocusGained(Widget *OldFocus);
   virtual void FocusRestore();
   virtual void Mouse(const MouseEvent &Event);
   virtual Point IdealSize();
   virtual void Layout();
   
   public:
   
   virtual void Realize();
   
   MenuBar(Widget *Parent = 0);
};

class MenuPopup : public BasicWidget
{
   Widget *OldParent;
   
   // Draws the menu bar
   virtual bool Key(const KeyEvent &Key,Widget *Source);
   virtual void FocusLost(Widget *);
   virtual void FocusRestore();
   virtual void Mouse(const MouseEvent &Event);
   virtual Point IdealSize();
   virtual void Layout();
   
   public:
   
   virtual void Realize();
   virtual void UnRealize();
   
   MenuPopup(Widget *Parent = 0);
};

#endif
