#pragma interface
#ifndef INTERNAL_H
#define INTERNAL_H

#ifndef MISC_H
	#include <misc.h>
#endif
#ifndef MODULE_H
	#include <module.h>
#endif

#ifndef NETCONF_H
	#include <netconf.h>
#endif

#ifndef MODAPI_H
	#include <modapi.h>
#endif
#ifndef MODAPI_DEF_H
	#include <modapi_def.h>
#endif



class SAMBA_HELP_FILE: public HELP_FILE{
	/*~PROTOBEG~ SAMBA_HELP_FILE */
public:
	SAMBA_HELP_FILE (const char *fname);
	/*~PROTOEND~ SAMBA_HELP_FILE */
};


class MODULE_SAMBA: public LINUXCONF_MODULE{
	/*~PROTOBEG~ MODULE_SAMBA */
public:
	MODULE_SAMBA (void);
	int domenu (MENU_CONTEXT context, const char *key);
	int execmain (int argc, char *argv[]);
	int message (const char *msg,
		 int argc,
		 const char *argv[]);
	void setmenu (DIALOG&dia, MENU_CONTEXT context);
	void usage (SSTRINGS&tb);
	/*~PROTOEND~ MODULE_SAMBA */
};

class SMB_ITEM: public ARRAY_OBJ{
public:
	SSTRING comment;
	SSTRING key;
	SSTRING val;
	/*~PROTOBEG~ SMB_ITEM */
public:
	SMB_ITEM (const char *_comment, const char *line);
	SMB_ITEM (void);
	void write (FILE *fout)const;
	/*~PROTOEND~ SMB_ITEM */
};

class SMB_ITEMS: public ARRAY{
	/*~PROTOBEG~ SMB_ITEMS */
public:
	SMB_ITEM *getitem (const char *key)const;
	SMB_ITEM *getitem (int no)const;
	const char *getval (const char *key)const;
	const char *getval (const char *key1,
		 const char *key2,
		 const char *key3)const;
	void setval (const char *key, const SSTRING&val);
	void setval (const char *key, const char *val);
	void setval (const char *key, int num);
	void setval (const char *key1,
		 const char *key2,
		 const char *key3,
		 const SSTRING&val);
	void setval (const char *key1,
		 const char *key2,
		 const char *key3,
		 const char *val);
	void setval (const char *key1,
		 const char *key2,
		 const char *key3,
		 int num);
	void write (FILE *fout)const;
	/*~PROTOEND~ SMB_ITEMS */
};

// Input field type
enum SMB_FIELD_TYPE{
	SMB_STR,		// newf_str
	SMB_NUM,		// newf_num
	SMB_CHK,		// newf_chk
	SMB_CHKON,		// newf_chk, default to on if the field is not defined
	SMB_BOOK,		// Not really a field, used to present large dialogs
					// as notebooks
	SMB_ENUMH,		// Enumeration presented horizontally
	SMB_COMBO,		// Text field with a help list
};

// Describe the zillions fields of the dialog
struct SMB_FIELD{
	const char *key1;
	const char *key2;
	const char *key3;
	SMB_FIELD_TYPE type;
	void *extra;		// More info for the field type
	const char *title;
};

struct SMB_FIELD_VAL{
	SSTRING str;
	char chk;
	char enm;	// Enumerate value
	int num;
};


class SMB_SHARE: public ARRAY_OBJ{
public:
	SSTRING comment;
	SSTRING name;
	SMB_ITEMS items;
	/*~PROTOBEG~ SMB_SHARE */
public:
	SMB_SHARE (const char *_comment, const char *_name);
	SMB_SHARE (void);
	int edit (void);
	int editgen (DIALOG&dia,
		 SMB_FIELD tbf[],
		 int nbf,
		 bool may_del,
		 SAMBA_HELP_FILE&help_file);
	int editglobal (void);
	int edithomes (void);
	int editnetlogon (SMB_SHARE *glob);
	int editprinters (void);
	const char *getval (const char *key)const;
	const char *getval (const char *key1,
		 const char *key2,
		 const char *key3)const;
private:
	void savedia (SMB_FIELD tbf[],
		 int nbf,
		 SMB_FIELD_VAL tbv[]);
	void setdia (DIALOG&dia,
		 SMB_FIELD tbf[],
		 int nbf,
		 SMB_FIELD_VAL tbv[]);
public:
	void setval (const char *key, const SSTRING&val);
	void setval (const char *key, int num);
	void setval (const char *key1,
		 const char *key2,
		 const char *key3,
		 const SSTRING&val);
	void setval (const char *key1,
		 const char *key2,
		 const char *key3,
		 const char *val);
	void setval (const char *key1,
		 const char *key2,
		 const char *key3,
		 int num);
	void write (FILE *fout)const;
	/*~PROTOEND~ SMB_SHARE */
};

class SMB_SHARES: public ARRAY{
	/*~PROTOBEG~ SMB_SHARES */
public:
	SMB_SHARE *getitem (const char *name)const;
	SMB_SHARE *getitem (int no)const;
	int write (void);
	/*~PROTOEND~ SMB_SHARES */
};

class SMB_CONF{
	SMB_SHARES shares;
public:
	char syncpass;
	/*~PROTOBEG~ SMB_CONF */
public:
	SMB_CONF (void);
	void edit (void);
	void editdefaults (void);
	void edithomes (void);
	void editnetlogon (void);
	void editprinters (void);
	int editshares (void);
	int sanitycheck (void);
	int write (void);
	/*~PROTOEND~ SMB_CONF */
};

extern const char subsys_samba[];

#include "samba.p"

#endif

