/* ***********

	Check comments starting with // ### and fill appropriate code there

   ***********
*/
#pragma implementation
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "conectiva.h"
#include "conectiva.m"
#include <netconf.h>
#include <userconf.h>

MODULE_DEFINE_VERSION(conectiva);

PUBLIC MODULE_conectiva::MODULE_conectiva()
	: LINUXCONF_MODULE("conectiva")
{
	linuxconf_loadmsg ("conectiva",PACKAGE_REV);
	linuxconf_sethook (filter_fctnew);
	hostinfo_sethook (devinfo_load,devinfo_save);
	groutes_sethook (routes_load,routes_save);
	ipalias_sethook (devinfo_ipalias_load,devinfo_ipalias_save);
	users_sethook (reduser_del,reduser_add,reduser_change);
	#if defined(__GLIBC__) && defined(HAS_PAM)
		passwd_sethook (pam_check_pass,pam_change_pass,pam_check_pair);
	#endif
}



PUBLIC int MODULE_conectiva::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"conectiva")==0){
		// ### Insert any menu and dialog here
		ret = 0;
	}
	return ret;
}


static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"conectiva usage\n"
		 "\n"
		 "conectiva --option ...\n")
		);
}

PUBLIC int MODULE_conectiva::execmain (int argc , char *argv[])
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"conectiva")==0){
		ret = -1;
		if (argc == 1){
			// ### Place call to main menu of the module
		}else{
			// ### Add some option parsing for the module
			::usage();
		}
	}
	return ret;
}


static MODULE_conectiva conectiva;

const char *vendor_getid()
{
	return "Conectiva";
}

const char *vendor_getdistid()
{
	return "Guarani";
}

