#include "diawxxt.h"


PUBLIC CLIST::CLIST (
	FORMBASE *_parent,
	const char *_id,
	int _nbcol,
	const char *_cols[])
	: MFORM (_parent,_id)
{
	sub = new MFORM(this,"");
	New_form(sub);
	nbcol = _nbcol;
	cols = new char *[_nbcol];
	wxDC *dc = GetDC();
	int maxh = 0;
	for (int i=0; i<_nbcol; i++){
		const char *s = _cols[i];
		cols[i] = strdup(s);
		float w,h;
		dc->GetTextExtent (s,&w,&h);
		int wi = (int)w+5;
		int hi = (int)h;
		sub->mincols[i] = wi;
		if (hi > maxh) maxh = hi;
	}
	marge_droite = marge_gauche = 5;
	marge_haut = maxh + 5;
	marge_bas = 5;
}

PUBLIC CLIST::~CLIST ()
{
	for (int i=0; i<nbcol; i++){
		free (cols[i]);
	}
	delete [] cols;
}

/*
	Add a new line
*/
PUBLIC void CLIST::New_item (const char *id, const char *items[])
{
	for (int i=0; i<nbcol; i++){
		sub->New_buttonfill (id,items[i]);
	}
	sub->Newline();
}
/*
	Set the value of an existing line or add a new line
*/
PUBLIC void CLIST::Set_item (const char *id, const char *items[])
{
	bool found = false, redo=false;
	for (int i=0; i<sub->nbc; i++){
		MFORM_C *c = sub->tbc[i];
		if (strcmp(c->id,id)==0){
			found = true;
			for (int j=0; j<nbcol; j++){
				MFORM_C *n = sub->tbc[i+j];
				n->sets (items[j]);
				float w,h;
				dc->GetTextExtent (n->s,&w,&h);
				int wi = (int)w;
				if (n->pref_width < wi) redo = true;
			}
			if (!redo){
				sub->drawitems (i,i+nbcol,true);
			}
			break;
		}
	}
	if (!found) New_item (id,items);
	if (!found || redo){
		gettop()->mainlayout();
	}
}

/*
	Draw the heading of the list and the decoration around the list.
*/
PUBLIC void CLIST::drawhead()
{
	wxDC *dc = GetDC();
	int x = 8;
	float w,h;
	dc->GetTextExtent ("WWW",&w,&h);
	int y = (int)h+2;
	for (int i=0; i<nbcol; i++){
		dc->SetPen (pen_black);
		dc->DrawText (cols[i],x,0);
		int width = sub->colwidth[i];
		dc->DrawLine (x,y,x+width-4,y);
		x += width;
	}
}
PUBLIC void CLIST::OnPaint()
{
	MFORM::OnPaint();
	drawhead();
}


