/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *   Gnome Apt frontend
 *
 *   Copyright (C) 1998 Havoc Pennington <hp@pobox.com>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GNOME_APT_GNOME_APT_H
#define GNOME_APT_GNOME_APT_H

#include <config.h>
#include <gnome.h>

#define APPNAME "gnome-apt"
#define COPYRIGHT_NOTICE _("Copyright 1998, GNU General Public License.")

// Initiate quit sequence - check sanity, ask if we're sure, etc.
void gnome_apt_quit(void);

// Append anything on error_ to message and display.
void gnome_apt_error_dialog(const char* message);
// Same but modal and quit the app when it closes.
void gnome_apt_fatal_dialog(const char* message);

// This mostly just sets the dialog as a transient of the main window,
//  so we don't have to keep a pointer to the main window around
//  all over the place.
void gnome_apt_setup_dialog(GtkWidget* dialog);

// pack widget and label in hbox, return hbox
GtkWidget* gnome_apt_labelled_widget(const gchar* label, GtkWidget* widget);

// Debug spew - not used yet, mostly.

#ifdef GNOME_ENABLE_DEBUG
#ifdef	__GNUC__
#define	ga_debug(format, args...)	g_log (G_LOG_DOMAIN, \
					       G_LOG_LEVEL_DEBUG, \
					       format, ##args)
#else	/* !__GNUC__ */
static inline void
ga_debug (const gchar *format,
	 ...)
{
  va_list args;
  va_start (args, format);
  g_logv (G_LOG_DOMAIN, G_LOG_LEVEL_DEBUG, format, args);
  va_end (args);
}
#endif	/* !__GNUC__ */

#else /* GNOME_ENABLE_DEBUG */
#ifdef __GNUC__
#define ga_debug(format, args...)
#else
static inline void 
ga_debug (const gchar* format, ...) {}
#endif /* !GNUC */
#endif /* !GNOME_ENABLE_DEBUG */

#endif
