/*  extipl.h -  header for extipl modules
 *		Auther:	KIMURA Takamiti<takamiti@tsden.org>
 */

#define VERSION			"ver 4.2 1999/04/05"

#define IPL_SIZE		446
#define SECTOR_SIZE		512
#define NR_PARTITION		4
#define TBL_ENTRY_SIZE		16
#define TABLE_SIZE		(NR_PARTITION * TBL_ENTRY_SIZE)
#define IPL_MAGIC_POS		510
#define IPL_MAGIC		0xaa55

#define LBUF_SIZE		256

#define EXTDOS_PART		0x05
#define EXTLINUX_PART		0x85
#define try_recursiv(n)		((n)==EXTDOS_PART || (n)==EXTLINUX_PART)

#define ctrl(c)			((c) - 0x40)
#define between(a, l, u)	((unsigned short)((a)-(l)) <= ((u)-(l)))
#define bell()			printf("\007")

typedef unsigned char byte;

typedef struct hdadr_s {
	byte  head;
	byte  sect;
	byte  cyl;
    } hdadr_s;

typedef struct offset_s {
	hdadr_s        chs;
	unsigned long  lba;
	unsigned long  base;
    } offset_s;

typedef struct tblchain_s {
	struct offset_s    offset;
	char               sector[SECTOR_SIZE];
	struct tblchain_s  *next[NR_PARTITION];
    } tblchain_s;

typedef struct partition_s {
	byte	       bootind;
	hdadr_s        start_chs;
	byte	       sysind;
	hdadr_s        end_chs;
	unsigned long  sector_offset;
	unsigned long  nr_sector;
    } partition_s;

typedef struct sysident_s {
	int   id;
	int   bootable;
	char  *name;
    } sysident_s;

struct sysident_s sysident[] = {
	{ 0x01,   1,  "FAT12" },
	{ 0x02,   1,  "XENIX root" },
	{ 0x03,   0,  "XENIX filesystem" },
	{ 0x04,   1,  "FAT16(<=32MB)" },
	{ 0x05,   0,  "Extended DOS" },
	{ 0x06,   1,  "FAT16(>32MB)" },
	{ 0x07,   1,  "NTFS/HPFS" },
	{ 0x08,   1,  "AIX bootable" },
	{ 0x09,   0,  "AIX filesystem" },
	{ 0x0A,   1,  "IBM boot manager" },
	{ 0x0B,   1,  "FAT32" },
	{ 0x0C,   1,  "FAT32 LBA" },
	{ 0x0E,   1,  "VFAT LBA" },
	{ 0x0F,   1,  "VFAT LBA(2)" },
	{ 0x10,   0,  "OPUS" },
	{ 0x11,   0,  "Hidden FAT12" },
	{ 0x12,   0,  "Compaq Diagnostics" },
	{ 0x14,   0,  "Hidden FAT(<=32MB)" },
	{ 0x16,   0,  "Hidden FAT(>32MB)" },
	{ 0x17,   0,  "Hidden HPFS" },
	{ 0x18,  -1,  "AST 0v suspend swap" },
	{ 0x24,   1,  "NEC DOS 3.x" },
	{ 0x38,   1,  "Theos" },
	{ 0x3C,  -1,  "Partition Magic recoverry" },
	{ 0x40,   1,  "VENIX 286" },
	{ 0x41,   1,  "Personal RISC boot" },
	{ 0x42,   0,  "Secure Filesystem" },
	{ 0x50,  -1,  "Ontrack Diskmanager RO" },
	{ 0x51,  -1,  "Ontrack Diskmanager RW" },
	{ 0x52,   1,  "CP/M or Microport SysV/AT" },
	{ 0x53,  -1,  "Ontrack Diskmanager WO" },
	{ 0x54,  -1,  "Ontrack Diskmanager DDO" },
	{ 0x56,   1,  "Golden Bow VFeature" },
	{ 0x61,   0,  "SpeedStor" },
	{ 0x63,   1,  "ISC UNIX/SystemV-386/GNU HURD/Mach" },
	{ 0x64,   1,  "Netware 286" },
	{ 0x65,   1,  "Netware 3.11" },
	{ 0x66,   1,  "Netware 386" },
	{ 0x67,   0,  "Novell type 67" },
	{ 0x68,   0,  "Novell type 68" },
	{ 0x69,   0,  "Novell type 69" },
	{ 0x70,   1,  "DiskSecure multiboot" },
	{ 0x75,   1,  "PC/IX" },
	{ 0x80,   1,  "Minix 1.1" },
	{ 0x81,   1,  "Minix 1.4 or later" },
	{ 0x82,  -1,  "Linux swap" },
	{ 0x83,   1,  "Linux native" },
	{ 0x84,   0,  "Hidden DOS 3" },
	{ 0x85,   0,  "Linux extended" },
	{ 0x86,   0,  "NTFS striped FAT" },
	{ 0x87,   0,  "NTFS striped" },
	{ 0x93,   1,  "Ameoba Filesystem" },
	{ 0x94,  -1,  "Ameoba bad block table" },
	{ 0xA0,   0,  "Phoenix power management" },
	{ 0xA5,   1,  "FreeBSD/NetBSD/386BSD" },
	{ 0xA6,   1,  "OpenBSD" },
	{ 0xA7,   1,  "NEXTSTEP" },
	{ 0xB7,   1,  "BSDI BSD/386 native" },
	{ 0xB8,  -1,  "BSDI BSD/386 swap" },
	{ 0xC7,   1,  "Syrix boot" },
	{ 0xD8,   1,  "CP/M-86" },
	{ 0xDB,   1,  "Concurrent-CPM/C.DOS/CTOS" },
	{ 0xE1,   0,  "Speedstor EXT" },
	{ 0xE3,   0,  "Storage dimensions" },
	{ 0xE4,   0,  "Speedstar EXT" },
	{ 0xF1,   0,  "Storage dimensions" },
	{ 0xF2,   0,  "DOS 3.3 2nd partition" },
	{ 0xF4,   0,  "Speedstor" },
	{ 0xFE,   0,  "IBM PS/2 IML" },
	{ 0xFF,  -1,  "Bad block table" },
	{ 0x00,  -1,  "empty partition" },
	{   -1,   0,  "unknown"}
    };

/* end of extipl.h */
