;;  lba_main.asm:
;;	main routine for both CHS/LBA access supported Extnded-IPL
;;
;;	Written by KIMURA Takamichi <takamiti@tsden.org> 1999/04/05
;;

start:		test	byte [kbd_stat],SHIFT_BIT
		jz	chkTable
		inc	dx
chkTable:	call	initCRT
		push	word chkTable
		mov	cx,4
		mov	di,PART_TAB
		mov	bx,0x3130
		mov	si,guid_msg
		call	putstr
chtabloop:	inc	bx
		test	byte [di],0x80
		jz	prntab
		mov	bh,bl
		or	dx,dx
		jz	bootProc
		and	byte [di],0x7F
prntab:		mov	al,bl
		call	putch
		mov	al,byte [di+4]
		or	al,al
		jz	nosys
		push	ax
		mov	ax,0x0273
		call	putSPC
		pop	ax
		call	hex2
nosys:		add	di,16
		call	putCRLF
		loop	chtabloop
		inc	dx

retry0:		mov	bl,bh
retry1:		push	bx
retry:		mov	si,selmsg
		call	putstr
keyin:		pop	ax
		call	putch
keyin1:		xor	ah,ah
		int	KEYBIOS
		cmp	al,0x30
		jc	selOK
		cmp	al,0x34
		ja	keyin1
		xchg	ax,bx
		jmp	short retry1

selOK:		cmp	ah,ENTER_KEY
		jnz	keyin1

bootProc:	push	dx
		mov	bh,bl
		sub	bl,0x30
		jz	switch_HD

		dec	bx
		mov	al,16
		mul	bl
		add	ax,PART_TAB
		mov	di,ax
		xchg	ax,si			; partition table address in si
		lodsw
		xchg	ax,dx
		lodsw
		xchg	ax,cx
		lodsw
		inc	si
		inc	si
		or	al,al
		jz	boot9
		push	di
		push	ax
		xchg	ax,di
		lodsw
		xchg	ax,bx
		lodsw
		xchg	ax,bx
		xchg	ax,di
		call	is_extid
		xchg	ax,di
		mov	di,(adr_packet + 8)
		jnz	boot0

		mov	di,base_offset
		or	bp,bp
		jnz	boot1
		inc	bp
		stosw
		xchg	ax,bx
		stosw
		xchg	ax,bx
		jmp	short boot2

boot0:		or	bp,bp
		jz	boot2
boot1:		add	ax,[di]
		adc	bx,[di+2]
boot2:		mov	dl,byte [drive]
		add	dl,0x50
		call	HDread
		pop	ax
		pop	si
		cmp	word [BIOS_LOC + 0x1FE],IPL_MAGIC
		jz	checksysid
boot9:		pop	dx
		jmp	short bell

checksysid:	mov	ah,byte [prompt]
		inc	ah
		call	is_extid
		jz	moveTable

kickOS:		mov	byte [si],dl
		call	initCRT
		jmp	BIOS_LOC		;; jmp	far BIOS_LOC


		;  try next unit
switch_HD:	mov	al,byte [drive]
		sub	al,0x30
		inc	ax
		cmp	al,byte [nr_hdds]
		jc	sw_next
		xor	ax,ax
sw_next:	push	ax
		add	al,0x30
		mov	byte [drive],al
		pop	dx
rdsector00:	or	dl,0x80
		xor	ax,ax
		xor	bp,bp
		xor	bx,bx
		xor	dh,dh
		mov	cx,1
		call	HDread
		mov	ah,PS0
moveTable:	mov	byte [prompt],ah
		mov	si,(BIOS_LOC + 0x01BE)
		mov	di,PART_TAB
		mov	cx,33
		repnz	movsw
		pop	dx
		ret


;   input parameters:
;	bx:ax	= absolute block address(for LBA access)
;	dx	= head address(for CHS access) and drive unit no.
;	cx	= cylinder and sector address(for CHS access)
HDread:		mov	di,adr_packet
		push	di
		xchg	ax,si
		mov	ax,16
		stosw
		mov	ax,1
		stosw
		mov	ax,BIOS_LOC
		stosw
		push	ax
		xor	ax,ax
		stosw
		xchg	ax,si
		stosw
		xchg	ax,bx
		stosw
		xor	ax,ax
		stosw
		stosw
		mov	ah,0x41
		mov	bx,0x55aa
		int	DISKBIOS
		pop	bx
		pop	si
		mov	ah,0x42
		jnc	int13func
		mov	ax,0x0201
int13func:	int	DISKBIOS
		jnc	return
bell:		mov	al,BELL
		jmp	short putch

initCRT:	mov	ax,2
		jmp	short putch1
putspace:	mov	al,0x20
putch:		mov	ah,14
putch1:		int	VIDEOBIOS
return:		ret

putCRLF:	mov	si,crlf_msg
putstr:		lodsb
		or	al,al
		jz	return
		call	putch
		jmp	short putstr

hex2:		push	ax
		push	cx
		mov	cl,4
		shr	al,cl
		pop	cx
		call	hex1
		pop	ax
hex1:		and	al,0x0F
		add	al,0x30
		cmp	al,0x3A
		jc	putch
		add	al,7
		jmp	short putch

putSPC:		push	ax
		call	putspace
		pop	ax
		dec	ah
		jnz	putSPC
		jmp	short putch

is_extid:	cmp	al,EXTDOS_PART
		jz	is_extid9
		cmp	al,EXTLINUX_PART
is_extid9:	ret

guid_msg:	db	"No Sys"
crlf_msg:	db	CR, LF, NULL
selmsg:		db	CR, "#"
drive:		db	"0:"
prompt:		db	PS0, ".", NULL

;;  end of lba_main.asm
