/*
    ext2resize.c -- ext2 resizer frontend
    Copyright (C) 1998,99 Lennert Buytenhek <lbuijten@cs.leidenuniv.nl>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include "ext2.h"


int main(int argc, char *argv[])
{
	struct ext2_dev_handle *handle;
	struct ext2_fs	*fs;
	blk_t		 newsize;

	if (argc != 3)
	{
		fprintf(stderr, "syntax: %s <device> <new size>\n", argv[0]);
		exit(-1);
	}

	handle = ext2_make_dev_handle_from_file(argv[1]);
	if (handle == NULL)
	{
		fprintf(stderr, "cant open %s\n", argv[1]);
		return 1;
	}

	sscanf(argv[2], "%i", &newsize);

#if 1
	/* HACK */
	if (1)
	{
		blk_t x;
		
		x = (howmany(newsize, 4096) + 31) & ~0x1f;
		if (ext2_max_groups < x)
			ext2_max_groups = x;
	}
#endif

	if ((fs = ext2_open(handle)) == NULL)
	{
		fprintf(stderr, "cant open %s\n", argv[1]);
		exit(-1);
	}

	ext2_resize_fs(fs, newsize);
	ext2_close(fs);

	return 0;
}
