/*
    ext2_meta.c -- ext2 metadata mover
    Copyright (C) 1999 Lennert Buytenhek <lbuijten@cs.leidenuniv.nl>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include "ext2.h"

int ext2_metadata_push(struct ext2_fs *fs, blk_t newsize)
{
	int   i;
	int   newgdblocks;
	blk_t newitoffset;

	newgdblocks = howmany(newsize - fs->sb.s_first_data_block, fs->sb.s_blocks_per_group);
	newgdblocks = howmany(newgdblocks * sizeof(struct ext2_group_desc), fs->blocksize);
	newitoffset = newgdblocks + 3;

	if (newitoffset <= fs->itoffset)
		return 1;

	fprintf(stderr, "ext2_metadata_push %i to %i\n", fs->itoffset, newitoffset);

#if 1	/* debugging band-aid */
	for (i=0;i<fs->numgroups;i++)
	{
		blk_t diff;
		blk_t fromblock;
		int   j;
		blk_t start;

		start = (i * fs->sb.s_blocks_per_group) + fs->sb.s_first_data_block;
		if (fs->gd[i].bg_inode_table >= start + newitoffset
		    && fs->gd[i].bg_block_bitmap >= start + newitoffset - 2
		    && fs->gd[i].bg_inode_bitmap >= start + newitoffset - 1)
			continue;
		diff = newitoffset - (fs->gd[i].bg_inode_table - start);
		fromblock = fs->gd[i].bg_inode_table + fs->inodeblocks;
		for (j=0;j<diff;j++)
			if (ext2_get_block_state(fs, fromblock+j))
			{
				fprintf(stderr, "error: block relocator should have relocated %i\n", fromblock);
				return 0;
			}
	}
#endif

	for (i=0;i<fs->numgroups;i++)
	{
		blk_t diff;
		int   j;
		blk_t fromblock;
		blk_t start;

		start = (i * fs->sb.s_blocks_per_group) + fs->sb.s_first_data_block;

		if (fs->gd[i].bg_inode_table >= start + newitoffset
		    && fs->gd[i].bg_block_bitmap >= start + newitoffset - 2
		    && fs->gd[i].bg_inode_bitmap >= start + newitoffset - 1)
			continue;

		diff = newitoffset - (fs->gd[i].bg_inode_table - start);

		/* inode table */
		fromblock = fs->gd[i].bg_inode_table + fs->inodeblocks;
		for (j=0;j<diff;j++)
			ext2_set_block_state(fs, fromblock+j, 1, 0);
		ext2_move_blocks(fs, fs->gd[i].bg_inode_table, fs->inodeblocks, fs->gd[i].bg_inode_table+diff);
		fs->gd[i].bg_inode_table += diff;
		fs->metadirty = 1;
		ext2_sync(fs);


		/* block bitmap and inode bitmap */
		fromblock = fs->gd[i].bg_inode_table;
		if (ext2_is_group_sparse(fs, i))
		{
			ext2_copy_block(fs, fs->gd[i].bg_inode_bitmap, fs->gd[i].bg_inode_bitmap+diff);
			fs->gd[i].bg_inode_bitmap += diff;
			fs->metadirty = 1;
			ext2_sync(fs);

			ext2_copy_block(fs, fs->gd[i].bg_block_bitmap, fs->gd[i].bg_block_bitmap+diff);
			fs->gd[i].bg_block_bitmap += diff;
			fs->metadirty = 1;
			ext2_sync(fs);

			fromblock = fs->gd[i].bg_block_bitmap;
		}

		for (j=0;j<diff;j++)
			ext2_set_block_state(fs, fromblock+j-diff, 0, 0);
	}

	fs->itoffset = newitoffset;

	return 1;
}
