
#include <std.h>

#include "sections.h"

sectdesc_t Sections[] = {
	{"alien", "Packages that are not part of the standard distribution"}
	,

	{"admin", "Administration packages for super users"}
	,
	{"base", "Base packages for a normal installation"}
	,
	{"comm", "Communications packages; modem, packet radio, etc."}
	,
	{"devel", "Development (languages, interpreters, compilers, libraries)"}
	,
	{"doc", "Documentation, manuals and other information"}
	,
	{"editors", "Text editors (console and X-based)"}
	,
	{"electronics", "Circuit and electronic related packages"}
	,
	{"games", "Entertainment packages for X11/console"}
	,
	{"graphics", "Graphical viewers and design programs"}
	,
	{"hamradio", "Amateur radio and related packages"}
	,
	{"interpreters", "Language interpreters (perl, python, pike, etc)"}
	,
	{"libs", "Common system and other shared libraries"}
	,
	{"mail", "Mail user (client apps) and transfer (server apps) agents"}
	,
	{"math", "Computation programs (calculators, education, etc)"}
	,
	{"misc", "Miscellaneous (Un-sectioned) Packages"}
	,
	{"net", "Networking packages (servers, clients)"}
	,
	{"news", "Usenet (NNTP/NNRP) client/servers"}
	,
	{"oldlibs", "Old shared libraries (libc5, defunct libs)"}
	,
	{"otherosfs", "Packages that deal with other operating or filing systems"}
	,
	{"shells", "Common shells (bash/csh/zsh/ash/etc)"}
	,
	{"sound", "Audio (music) applications"}
	,
	{"tex", "Various TEX implementations"}
	,
	{"text", "Applications that involve text processing or editing"}
	,
	{"utils", "Common utilities"}
	,
	{"web", "World Wide Web servers, browsers, and HTML pre-processors"}
	,
	{"x11", "X11 Windowing System and related games, utilities, helpers"}
	,
	{NULL, NULL}
};

char *Section_Lookup(char *Name)
{
	for (sectdesc_t * X = Sections; X->Name != NULL; X++)
		if (strcmp(X->Name, Name) == 0)
			return X->Description;

	return Name;
}
