
#ifndef _pairs_H
#define _pairs_H

/*
 * Standard colors - old ncurses compatability
 */

#ifndef COLOR_PAIRS
#define COLOR_BLACK    0
#define COLOR_RED      1
#define COLOR_GREEN    2
#define COLOR_YELLOW   3
#define COLOR_BLUE     4
#define COLOR_MAGENTA  5
#define COLOR_CYAN     6
#define COLOR_WHITE    7
#endif

/*
 * Color pair combinations
 */

#define MAX_PAIRS 255

extern unsigned PairCount;

typedef struct
{
	short Pair;
	unsigned char fore_color;
	unsigned char back_color;
} PairList;

extern PairList *Pairs[];

/*
 * Practical applcation color definitions
 */

#define CAPT_COLOR_BACK              COLOR_BLACK
#define CAPT_COLOR_DIVIDER_BACK      COLOR_BLACK

#define CAPT_COLOR_DEFAULT           COLOR_WHITE
#define CAPT_COLOR_CURSOR            COLOR_BLACK
#define CAPT_COLOR_INSTALLED         COLOR_GREEN
#define CAPT_COLOR_NOT_UPGRADED      COLOR_GREEN
#define CAPT_COLOR_SEARCH_MATCH      COLOR_MAGENTA
#define CAPT_COLOR_UPGRADE_MARK      COLOR_CYAN
#define CAPT_COLOR_INSTALL_MARK      COLOR_YELLOW
#define CAPT_COLOR_REMOVE_MARK       COLOR_RED

#define CAPT_COLOR_DIVIDER_STATE     COLOR_WHITE
#define CAPT_COLOR_DIVIDER_SECTION   COLOR_WHITE
#define CAPT_COLOR_DIVIDER_PRIORITY  COLOR_WHITE
#define CAPT_COLOR_DIVIDER_CUSTOM    COLOR_WHITE

#define CAPT_COLOR_TOP_FG            COLOR_WHITE
#define CAPT_COLOR_TOP_BG            COLOR_RED
#define CAPT_COLOR_STAT_FG           COLOR_WHITE
#define CAPT_COLOR_STAT_BG           COLOR_BLUE
#define CAPT_COLOR_DESC_FG           COLOR_WHITE
#define CAPT_COLOR_DESC_BG           COLOR_BLACK
#define CAPT_COLOR_DTOP_FG           COLOR_WHITE
#define CAPT_COLOR_DTOP_BG           COLOR_BLUE

#define DLGPAIR                      Pair(COLOR_WHITE, COLOR_BLUE)

extern int Pair(short, short);
extern void free_pairs(void);

#endif /* pairs_H */
