
#ifndef _wrappers_H
#define _wrappers_H

#include <string>

#include <ncurses.h>

#define CenterY(len) ((LINES-len)/2)
#define CenterX(len) ((COLS-len)/2)

class UniqueWindow
{ private:
	WINDOW * Title, *Body;
	int Length_Y, Length_X, Displacement_Y, Displacement_X;
	int Extra_Y, Extra_X;

      public:
	 WINDOW * body()
	{
		return Body;
	};
	WINDOW *title()
	{
		return Title;
	};

	int rows()
	{
		return Length_Y - Extra_Y;
	};
	int cols()
	{
		return Length_X - Extra_X;
	};

	void Refresh()
	{
		wrefresh(Body);
	};
	void Redraw()
	{
		redrawwin(Body);
		wrefresh(Body);
		redrawwin(Title);
		wrefresh(Title);
	};
	void Erase()
	{
		werase(Body);
	};
	void scrollable(bool toggle = true) { scrollok(Body, toggle);
	};

	int Getch()
	{
		return wgetch(Body);
	};

	void CreateWindows();
	void ChangeColor(int TitlePair = -1, int BodyPair = -1);
	void ChangeTitle(string);

	UniqueWindow::UniqueWindow(int, int, int, int);
	UniqueWindow::~UniqueWindow();
};

#endif
