
#include <std.h>
#include <func/apt.h>
#include <list/packages.h>
#include <list/screens.h>

void depend_expand(pkgCache::PkgIterator TargetPkg, PackageList::Package * Master)
{
	PackageList::Package * mal;

	pkgCache::DepIterator D;

	screen->Packages->AddFlag(Master, PackageList::Expanded);

	for (D = (*Cache)[TargetPkg].CandidateVerIter(*Cache).DependsList(); D.end() == false; D++)
	{
		if ((*Cache)[D.TargetPkg()].CandidateVerIter(*Cache).end() == false)
		{
			mal = screen->Packages->append(Master);

			screen->Packages->SetType(mal, PackageList::Pkg);

			if (strcmp(TargetPkg.Name(), D.TargetPkg().Name()) == 0)
				screen->Packages->AddFlag(mal, PackageList::Expanded);

			mal->p_parent = Master;
			mal->pkg = D.TargetPkg();

			mal->increment = Master->increment + 1;
		}
	}
}

void depend_destruct(PackageList::Package * Master)
{
	PackageList::Package * x, *z;

	screen->Packages->ClearFlag(Master, PackageList::Expanded);

	for (x = Master->next; x != NULL && x->p_parent == Master; x = z->next)
	{
		z = x->prev;
		depend_destruct(x);
		screen->Packages->remove(x);
	}
}
