



package Debian::DebConf::Question;
use strict;
use Debian::DebConf::ConfigDb;
use Debian::DebConf::Base;
use vars qw($AUTOLOAD @ISA);
@ISA=qw(Debian::DebConf::Base);


sub new {
	my $proto = shift;
	my $class = ref($proto) || $proto;
	my $self  = bless $proto->SUPER::new(@_), $class;
	$self->{flag_isdefault}='true';
	$self->{variables}={};
	return $self;
}

sub _expand_vars {
	my $this=shift;
	my $text=shift;
	
	my %vars=%{$this->variables};
	
	my $rest=$text;
	my $result='';
	while ($rest =~ m/^(.*?)\${([^{}]+)}(.*)$/sg) {
		$result.=$1;  # copy anything before the variable
		$result.=$vars{$2} if defined($vars{$2}); # expand the variable
		$rest=$3; # continue trying to expand rest of text
	}
	$result.=$rest; # add on anything that's left.
	
	return $result;
}


sub description {
	my $this=shift;
	return $this->_expand_vars($this->template->description);
}


sub extended_description {
	my $this=shift;
	return $this->_expand_vars($this->template->extended_description);
}


sub choices {
	my $this=shift;
	
	return $this->_expand_vars($this->template->choices);
}


sub choices_split {
	my $this=shift;
	
	return split(/,\s+/, $this->choices);
}


sub variables {
	my $this=shift;
	
	if (@_ == 0) {
		return $this->{variables};
	} elsif (@_ == 1) {
		my $varname=shift;
		return $this->{variables}{$varname};
	} else {
		my $varname=shift;
		my $varval=shift;
		return $this->{variables}{$varname} = $varval;
	}
}	


sub value {
	my $this = shift;
	
	if (@_ == 0) {
		return $this->{value} if (defined $this->{value});
		return $this->template->default;
	} else {
		return $this->{value} = shift;
	}
}


sub value_split {
	my $this=shift;
	
	return split(/,\s+/, $this->value);
}


sub owners {
	my $this=shift;
	
	if (@_) {
		my %owners=map { $_, 1 } split(/,\s*/, shift);
		$this->{'owners'}=\%owners;
	}
	
	if ($this->{'owners'}) {
		return join(", ", keys %{$this->{'owners'}});
	}
	else {
		return "";
	}
}


sub addowner {
	my $this=shift;
	my $owner=shift;

	my %owners;
	if ($this->{'owners'}) {
		%owners=%{$this->{'owners'}};
	}
	$owners{$owner}=1;
	$this->{'owners'}=\%owners;
}


sub removeowner {
	my $this=shift;
	my $owner=shift;
	
	my %owners;
	if ($this->{'owners'}) {
		%owners=%{$this->{'owners'}};
	}
	delete $owners{$owner};
	$this->{'owners'}=\%owners;
}

sub AUTOLOAD {
	my $this=shift;
	my $property = $AUTOLOAD;
	$property =~ s|.*:||; # strip fully-qualified portion

	$this->{$property}=shift if @_;
	return $this->{$property} if (defined $this->{$property});
	return $this->{template}->$property();
}


1
