



package Debian::DebConf::FrontEnd::Tty;
use Debian::DebConf::FrontEnd;
use strict;
use vars qw(@ISA);
@ISA=qw(Debian::DebConf::FrontEnd);

sub new {
	my $proto = shift;
	my $class = ref($proto) || $proto;
	my $self  = bless $proto->SUPER::new(@_), $class;
	$self->resize; # Get current screen size.
	$SIG{'WINCH'}=sub { $self->resize };
	return $self;
}


sub resize {
	my $this=shift;

	if (exists $ENV{'LINES'}) {
		$this->{'screenheight'}=$ENV{'LINES'};
	}
	else {
		($this->{'screenheight'})=`stty -a </dev/tty` =~ m/rows (\d+)/s;
		$this->{'screenheight'}=25 if ! $this->{'screenheight'};
	}

	if (exists $ENV{'COLUMNS'}) {
		$this->{'screenwidth'}=$ENV{'COLUMNS'};
	}
	else {
		($this->{'screenwidth'})=`stty -a </dev/tty` =~ m/columns (\d+)/s;
		$this->{'screenwidth'}=80 if ! $this->{'screenwidth'};
	}
}


1
