



package Debian::DebConf::Element::Noninteractive::Note;
use strict;
use Debian::DebConf::Element::Noninteractive;
use vars qw(@ISA);
@ISA=qw(Debian::DebConf::Element::Noninteractive);


sub show {
	my $this=shift;

	if (-x '/usr/bin/mail' &&
	    $this->question->flag_isdefault ne 'false') {
	    	my $title="Debconf: ".$this->frontend->title." -- ".
		   $this->question->description;
		$title=~s/'/\'/g;                                                                             # This comment here to work around stupid ' highlighting in jed
	    	open (MAIL, "|mail -s '$title' root") or return;
		print MAIL <<eof;
This note was sent to you because debconf was asked to make sure you saw it,
but debconf was running in noninteractive mode, or you have told it to not
pause and show you unimportant notes. Here is the text of the note:

eof
		print MAIL $this->question->extended_description || $this->question->description;
		print MAIL "\n";
		close MAIL;
	}
	
	$this->question->flag_isdefault('false');

	return '';
}

1
