


package Debian::DebConf::Config;
use strict;
use Debian::DebConf::ConfigDb;



sub dbdir {
"/var/lib/debconf/"
}


sub tmpdir {
"/var/lib/debconf/"
}


{
	my $override_frontend='';

	sub frontend {
		return ucfirst($ENV{DEBIAN_FRONTEND})
			if exists $ENV{DEBIAN_FRONTEND};
		
		if (@_) {
			$override_frontend=ucfirst(shift);
		}
	
		return $override_frontend if ($override_frontend);
	
		my $ret='Dialog';
		my $question=Debian::DebConf::ConfigDb::getquestion(
			'debconf/frontend'
		);
		if ($question) {
			$ret=$question->value || $ret;
		}
		return $ret;
	}
}


{
	my $override_priority='';

	sub priority {
		if (@_) {
			$override_priority=shift;
		}
	
		if ($override_priority) {
			return $override_priority;
		}
	
		my $ret='medium';
		my $question=Debian::DebConf::ConfigDb::getquestion(
			'debconf/priority'
		);
		if ($question) {
			$ret=$question->value || $ret;
		}
		return $ret;
	}
}


{
	my $override_showold;
	
	sub showold {
		if (@_) {
			$override_showold=shift;
		}
		
		if (defined $override_showold) {
			return $override_showold;
		}
		
		my $ret='false';
		my $question=Debian::DebConf::ConfigDb::getquestion(
			'debconf/showold',
		);
		if ($question) {
			$ret=$question->value || $ret;
		}
		return $ret;
	}
}


1
