# Author : David L. Johnson <dlj0@lehigh.edu>
# Probably broken by Jean-Marc Lasgouttes <Jean-Marc.Lasgouttes@inria.fr>
# modified and modularized by Emmanuel GUREGHIAN <gureghia@boston.bertin.fr>

# Including the maths stuff
#Input amsmaths.inc

# Including the maths stuff
Input amsmaths.inc

# the environnements copied from the old amsart.layout are :
# - Proof, 
# - Bibliography
# - Title
# - Author
# - Date
# - Abstract (This is a title component for this style.)
# - Address
# - Email
# - Keywords
# - Subjectclass


# I didn't make any change here in the style definitions ...


# Proof style declaration
Style Proof
  Margin		First_Dynamic
  LatexType		Environment
  LatexName		proof
  NextNoIndent		1
  LabelSep		xx
  ParIndent             MMM  
  ParSkip		0.4
  ItemSep		0.2
  TopSep		0.7
  BottomSep		0.7
  ParSep		0.3
  Align			Block
  AlignPossible		Block, Left
  LabelType		Static
  LabelString		"Proof."
  
  # standard font definition
  Font
    Shape               Up
    Size                Normal
  EndFont

  # label font definition
  LabelFont
    Shape               Italic
  EndFont

  # We don't want the preamble from Theorem
  Preamble
  EndPreamble 
End  

# Title style definition
Style Title
  # standard font definition
  Font
    Shape		Smallcaps
    Series 		Bold
    Size		Larger
  EndFont
End

# Author style definition
Style Author
  # standard font definition
  Font
    Size		Large
    Shape		Smallcaps
  EndFont
End

# Date style definition
Style Date
  LabelType		Static
  LabelString		"Date: "

  LabelFont
    Shape		Italic
    Size		Large
  EndFont
End

# Abstract style definition
Style Abstract 
  LatexType		CommandTitle
  ItemSep		0.2
  ParSep		0.3

  # label font definition
  LabelFont
    Shape		Smallcaps
  EndFont
End 


# Address style definition
Style Address
  Margin		Dynamic
  LatexType		CommandTitle
  LatexName		address
  ParSkip		0.4
  BottomSep		1.5
  ParSep		1.5
  Align			Left
  AlignPossible		Block, Left, Right, Center
  LabelType		Static
  LabelString		"Address: "
  # label font definition
  LabelFont
    Shape		Italic
  EndFont
End  

# Current Address style definition
Style Current_Address
  Margin		Dynamic
  LatexType		CommandTitle
  LatexName		curraddr
  ParSkip		0.4
  BottomSep		1.5
  ParSep		1.5
  Align			Left
  AlignPossible		Block, Left, Right, Center
  LabelType		Static
  LabelString		"Current address: "
  # label font definition
  LabelFont
    Shape		Italic
  EndFont
End  

# Email style definition
Style Email
  Margin		First_Dynamic
  LatexType		CommandTitle
  LatexName		email
  ParSkip		0.4
  BottomSep		1.5
  ParSep		1.5
  Align			Left
  AlignPossible		Block, Left, Right, Center
  LabelType		Static
  labelString		"E-mail address: "
  LabelFont
    Shape		Italic
  EndFont
End

# URL style definition
Style URL
  Margin		First_Dynamic
  LatexType		CommandTitle
  LatexName		urladdr
  ParSkip		0.4
  BottomSep		1.5
  ParSep		1.5
  Align			Left
  AlignPossible		Block, Left, Right, Center
  LabelType		Static
  labelString		"URL: "
  LabelFont
    Shape		Italic
  EndFont
End

# Keywords style definition
Style Keywords
  Margin		Dynamic
  LatexType		CommandTitle
  LatexName		keywords
  ParSkip		0.4
  BottomSep		1.5
  ParSep		1.5
  Align			Left
  AlignPossible		Block, Left, Right, Center
  LabelType		Static
  LabelString		"Key words and phrases: "
  # label font definition
  LabelFont
    Shape		Italic
  EndFont
End  

# Thanks style definition
Style Thanks
  Margin		Dynamic
  LatexType		CommandTitle
  LatexName		thanks
  ParSkip		0.4
  BottomSep		1.5
  ParSep		1.5
  Align			Left
  AlignPossible		Block, Left, Right, Center
  LabelType		Static
  LabelString		"Thanks: "
  # label font definition
  LabelFont
    Shape		Italic
  EndFont
End  

# Dedicatory style definition
Style Dedicatory
  Margin		Dynamic
  LatexType		CommandTitle
  LatexName		dedicatory
  ParSkip		0.4
  BottomSep		1.5
  ParSep		1.5
  Align			Left
  AlignPossible		Block, Left, Right, Center
  LabelType		Static
  LabelString		"Dedication: "
  # label font definition
  LabelFont
    Shape		Italic
  EndFont
End  


# Translator style definition
Style Translator
  Margin		Dynamic
  LatexType		CommandTitle
  LatexName		translator
  ParSkip		0.4
  BottomSep		1.5
  ParSep		1.5
  Align			Left
  AlignPossible		Block, Left, Right, Center
  LabelType		Static
  LabelString		"Translator: "
  # label font definition
  LabelFont
    Shape		Italic
  EndFont
End  

# Subjectclass style definition
Style Subjectclass
  Margin		Dynamic
  LatexType		CommandTitle
  LatexName		subjclass
  ParSkip		0.4
  BottomSep		1.5
  ParSep		1.5
  Align			Left
  AlignPossible		Block, Left, Right, Center
  LabelType		Static
  LabelString		"1991 Mathematics Subject Classification: "
  # label font definition
  LabelFont
    Shape		Italic
  EndFont
End 


# Bibliography style definition
Style Bibliography
  # standard font definition
  Font
    Size		Small
  EndFont

  # label font definition
  LabelFont
    Size		Normal
    Shape		Smallcaps
  EndFont
End

