package MakePreamble;
# This package reads a LaTeX preamble (everything before \begin{document}
#    and translates it to LaTeX.

use strict;

sub split_preamble {
# Split the file into two files, one with just the preamble
# Simply copy stuff verbatim, saving translation for later
    my ($InFileName, $PreambleName, $OutFileName) = (shift, shift, shift);

    open (INFILE, "<$InFileName");
    open (PREAMBLE, ">$PreambleName");
    open (OUTFILE, ">$OutFileName");

    # Copy everything up to "\begin{document}" into the preamble
    while (<INFILE>) {
        last if s/\Q\begin{document}\E//;
	print PREAMBLE $_;
    }
    die "Didn't find \Q\begin{document}\E command!" unless defined $_;
    print PREAMBLE $_; # *could* be command on the same line as \begin{doc}!
    warn "Put preamble into file $PreambleName\n";

    # Copy everything else into another file
    print OUTFILE '\begin{document}';
    while (<INFILE>) {
        print OUTFILE $_;
    }

    warn "Put rest of file into $OutFileName\n";
    close INFILE; close OUTFILE; close PREAMBLE;
    warn "Done splitting preamble\n";
} #end sub split_preamble



# Actually translate a LaTeX preamble (in a file) into a LyX preamble.
# Return it as a string
#
# First argument is the name of the file containing *only* the preamble
# Second argument is the LyX format (e.g., "2.15")
sub translate_preamble {
    my $PreambleName = shift;
    my $Format = shift;
    warn "Creating LyX preamble... \n";
    open (PREAMBLE, "<$PreambleName");

    # This is the string in which we're concatenating everything we translate
    my $LyXPreamble = "";

# It would be nice to read the defaults.lyx file but for now we don't bother
#my $lyxdir = "/v/karger/.lyx/";
#my $default_dir = "templates/";
#my $default_name = "defaults.lyx";
#my $default_file = $lyxdir . $default_dir . $default_name;
#print "Going to open default LyX file $default_file\n";
#open (DEFAULT_LYX,$default_file) or die "can't find default lyx file!";
# We could read the format from defaults.lyx
#    if ($fmt =~ /^\s*\\lyxformat [0-9.]+/) {
#        print $fmt
#    } else {
#        die "Need \\lyxformat command in first line of default lyx file!";
#    }
# AFTER printing the preamble, we would print other commands from defaults.lyx
#    while (($line = <DEFAULT_LYX>) !~ /^.*\\layout/) {
#        if ($line !~ /^\s*(\#|\\textclass\W)/) { #already printed this line
#	    print OUTFILE $line;
#	}
#    }

    # Write first two lines of the lyx file
    my ($nm, $dt);
    $nm = getlogin || getpwuid($<);
    $dt = localtime;
    $LyXPreamble .= "\#This file was created by <$nm> $dt\n";
    $LyXPreamble .= "\#LyX 0.12 (C) 1995-1998 Matthias Ettrich" .
                    "and the LyX Team\n";

    # Print \lyxformat.
    $LyXPreamble .= "\\lyxformat $Format\n";

    # Ignore everything up to the \documentclass
    my ($extra_options, $instr);
    while (<PREAMBLE>) {
        next if /^\s*$/ || /^\s*%/; # skip whitespace or comment
	# could just allow 'documentclass' and not support 2.09
	last if s/^\s*\\document(style|class)//;
	die "uncommented text before \\documentclass command";
    } # end while

    # Read optional arguments (they're printed AFTER the \\textclass command)
    s/\s*$Text::TeX::optionalArgument//;
    if ($extra_options = $1) { # i.e., if there were any optional arguments
	print "extra options are '$extra_options'\n";
	my @opt_args = split(",", $extra_options); # split up args for examining
    }

    # Read the document class, in braces, then convert it to a textclass
    s/\s*\{(\w+)\}//;
    my $class = $1;
    $LyXPreamble .= "\\textclass $class\n";
    print "document class is $class\n";

    # Convert extra \documentclass options to an \options command
    $LyXPreamble .= "\\options $extra_options\n" if $extra_options;

    # Now copy the whole preamble into the preamble of the LyX document
    #     (unless there is no preamble)
    # Everything until the end of filehandle PREAMBLE is preamble matter
    my $TeXPreamble = $_; # there COULD be a preamble command on same line
    my $write_preamble = (! /^\s*$/ && ! /^\s*%/);
    while (<PREAMBLE>) {
	$TeXPreamble .= $_;
	# write an official preamble if we find anything that's not comment
	$write_preamble ||= (! /^\s*$/ && ! /^\s*%/);
    }

    if ($write_preamble) {
	print "copying TeX preamble, consisting of:\n$TeXPreamble\n";
	$LyXPreamble .= "\\begin_preamble\n";
        $LyXPreamble .= $TeXPreamble;
	$LyXPreamble .= "\\end_preamble\n"; 
	print "Done Coyping TeX preamble\n";
    }

    warn "Done creating LyX Preamble\n";
    return $LyXPreamble;
}

1; # return true value to calling program
