//
// /home/ms/sidplay/qtsidplay/RCS/WaveViewDialog.cpp,v
//

#include "GlobalExt.h"
#include "WaveViewDialog.h"
#include <qpainter.h>
#include <math.h>

#include "images/waveview.xpm"

#define Inherited WaveViewDialogData

WaveViewDialog::WaveViewDialog
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
	setCaption( "Oscilloscope" );
	setFixedSize(width(),height());
	setIcon(*myMainIcon);
	
	shown = false;
	myWavePicOrig = new QPixmap(waveview_xpm);
}

WaveViewDialog::~WaveViewDialog()
{
	delete myWavePicOrig;
}

void WaveViewDialog::show()
{
	shown = true;
	QDialog::show();
}

void WaveViewDialog::done(int r)
{
	shown = false;
	QDialog::done(r);
}

bool WaveViewDialog::isShown()
{
	return shown;
}

//#include "AudioDriver.h"

static ubyte* lastBuffer = 0;

void WaveViewDialog::paintWaveformFunc(ubyte* pBuffer)
{
	lastBuffer = pBuffer;
	
	QColor myBeam1Color(0,255,0);  // rgb
	QColor myBeam2Color(0,255,192);  // rgb
	
	QPixmap myWavePic(width(),height());
	QColor myBgColor(0,0,0);  // rgb
	myWavePic.fill(myBgColor);
	
	QPainter paintBuf;
	paintBuf.begin(&myWavePic);
	paintBuf.drawPixmap(0,0,*myWavePicOrig);
	int dy = height()/2;
//	extern sidAudio myAudio;
	extern emuConfig myEmuConfig;
//	int di = myAudio.GetBufSize()/width();
	int di;
	int i = 0;
	if (myEmuConfig.bitsPerSample == SIDEMU_8BIT)
	{
		if (myEmuConfig.channels == SIDEMU_STEREO)
		{
			paintBuf.setPen(myBeam1Color);
			di = 2;
			// current point
			paintBuf.moveTo(0,dy);
			for (int x=0; x<width(); x++)
			{
				int y = (pBuffer[i]-128)/2;
				paintBuf.lineTo(x,dy-y);
				i += di;
			}
			paintBuf.setPen(myBeam2Color);
			i = 1;
			// current point
			paintBuf.moveTo(0,dy);
			for (int x=0; x<width(); x++)
			{
				int y = (pBuffer[i]-128)/2;
				paintBuf.lineTo(x,dy-y);
				i += di;
			}
		}
		else
		{
			paintBuf.setPen(myBeam1Color);
			di = 1;
			// current point
			paintBuf.moveTo(0,dy);
			for (int x=0; x<width(); x++)
			{
				int y = pBuffer[i]-128;
				paintBuf.lineTo(x,dy-y);
				i += di;
			}
		}
	}
	else  //if (myEmuConfig.bitsPerSample == SIDEMU_16BIT)
	{
		uword* pwBuffer = (uword*)pBuffer;
		if (myEmuConfig.channels == SIDEMU_STEREO)
		{
			paintBuf.setPen(myBeam1Color);
			di = 2;
			// current point
			paintBuf.moveTo(0,dy);
			for (int x=0; x<width(); x++)
			{
				int y = ((pwBuffer[i]>>8)-128)/2;
				paintBuf.lineTo(x,dy-y);
				i += di;
			}
			paintBuf.setPen(myBeam2Color);
			i = 1;
			// current point
			paintBuf.moveTo(0,dy);
			for (int x=0; x<width(); x++)
			{
				int y = ((pwBuffer[i]>>8)-128)/2;
				paintBuf.lineTo(x,dy-y);
				i += di;
			}
		}
		else
		{
			paintBuf.setPen(myBeam1Color);
			di = 1;
			// current point
			paintBuf.moveTo(0,dy);
			for (int x=0; x<width(); x++)
			{
				int y = ((pwBuffer[i]>>8)-128)/2;
				paintBuf.lineTo(x,dy-y);
				i += di;
			}
		}
	}
	
	paintBuf.end();
		
	QPainter paint(this);
	paint.drawPixmap(0,0,myWavePic);
}

void WaveViewDialog::paintEvent( QPaintEvent * )
{
	if (lastBuffer != 0)
		paintWaveformFunc(lastBuffer);
}

void WaveViewDialog::resizeEvent( QResizeEvent * )
{
	// Disabled.
}
