/*--------------------------------*-C-*---------------------------------*
 * This module is all new by Robert Nation
 * (nation@rocket.sanders.lockheed.com).
 *
 * Additional modifications by mj olesen <olesen@me.queensu.ca>
 * No additional restrictions are applied.
 *
 * As usual, the author accepts no responsibility for anything, nor does
 * he guarantee anything whatsoever.
 *----------------------------------------------------------------------*/
#ifndef _SCREEN_H
#define _SCREEN_H

typedef struct {
   int pwidth, pheight;	/* window size in pixels */
   int fwidth, fheight;	/* font width and height in pixels */
   int cols, rows;	/* window size in characters */
   int scrollback;	/* # lines to save in scrollback buffer */
   int offset;		/* how far back into the scrollback buffer */
   int scrolled;	/* how many scrolled lines saved */
   Window parent;	/* parent/main window */
   Window vt;		/* vt100 window */
} WindowInfo;
extern WindowInfo RxvtWin;

/* Screen refresh methods */
#define NO_REFRESH	2	/* Window not visible at all! */
#define SLOW_REFRESH	1	/* No Bitblt */
#define FAST_REFRESH	0

/*  flags for scr_move() */
#define ABSOLUTE	0
#define COL_RELATIVE	1	/* column movement is relative */
#define ROW_RELATIVE	2	/* row movement is relative */
#define RELATIVE	3	/* move row/column relative */

/* arguments to the screen delete functions */
#define DEL_END		0
#define DEL_START	1
#define DEL_ENTIRE	2

/* modes for scr_insdel_chars(), scr_insdel_lines() */
#define INSERT	-1
#define DELETE	+1
#define ERASE	+2		/* for scr_insdel_chars() */

#define UP	+1		/* modes for scr_page */
#define DOWN	-1

/* arguments for scr_change_screen() */
#define PRIMARY		0
#define SECONDARY	1

/* rendition style flags */
#define RS_NONE		0	/* Normal */
#define RS_FONTMASK	0x03	/* occupy two bits */
#define RS_CURSOR	0x04	/* cursor location */
#define RS_SELECTED	0x08	/* selected text */
#define RS_BOLD		0x10	/* bold */
#define RS_ULINE	0x20	/* underline */
#define RS_BLINK	0x40	/* blink */
#define RS_RVID		0x80	/* reverse video */

#define RS_ASCII	0	/* ASCII character set */
#define RS_GRFONT	1	/* graphics character set */
#define RS_GBFONT	2	/* UK character set */

#define FG_MASK		0x0000FF00
#define BG_MASK		0x00FF0000
#define ATTR_MASK	0x000000FF

/* how to build & extract colors and attributes */
#define GET_FG_COLOR(r)		((r & FG_MASK)>>8)
#define GET_BG_COLOR(r)		((r & BG_MASK)>>16)
#define GET_ATTR(r)		((r & ATTR_MASK))

#define SET_FG_COLOR(r,fg) (((r) & ~FG_MASK)   | ((fg) << 8))
#define SET_BG_COLOR(r,bg) (((r) & ~BG_MASK)   | ((bg) << 16))
#define SET_FGBG(r,fg,bg)  (((r) & ATTR_MASK)  | ((fg) << 8) | ((bg) << 16))
#define SET_ATTR(r,a)      (((r) & ~ATTR_MASK) | (a))

#ifdef __cplusplus
extern "C" {
#endif
   extern void	scr_init (void);
   extern void	scr_reset (void);
   extern void	scr_power_on (void);
   extern void	scr_bell (void);
   extern void	scr_backspace (void);
   extern int	scr_change_screen (int scrn);
   extern void	scr_rendition (int mode, int style);
   extern void	scr_focus (int in_focus);
   extern void	scr_add_lines (unsigned char *c, int nl_count, int n);
   extern void	scr_tab (int count);
   extern void	scr_move (int x, int y, int relative);
   extern void	scr_index (int direction);
   extern void	scr_save_cursor (void);
   extern void	scr_restore_cursor (void);
   extern void	scr_erase_line (int mode);
   extern void	scr_erase_screen (int mode);
   extern void	scr_insdel_lines (int count, int insdel);
   extern void	scr_insdel_chars (int count, int insdel);
   extern void	scr_scroll_region (int top, int bot);
   extern void	scr_move_to (int y);
   extern void	scr_page (int direction, int n);
   extern void	scr_selection_make (Time time);
   extern void	scr_selection_send (XSelectionRequestEvent *rq);
   extern void	scr_selection_request (Time time, int x, int y);
   extern void	scr_paste_primary (Window win, int prop, int Delete);
   extern void	scr_selection_clear (void);
   extern void	scr_selection_delete (void);
   extern void	scr_selection_extend (int hilite, int x, int y);
   extern void	scr_selection_start (int x, int y);
   extern void	scr_selection_multiclick (int clicks, int x, int y);
   extern void	scr_report_position (void);
   extern void	scr_touch (int x, int y, int width, int height);
   extern void	scr_set_charset (int set, unsigned char a);
   extern void	scr_choose_charset (int set);
   extern void	scr_refresh_region (int startr, int endr, int type);
   extern void	scr_refresh (int type);
   extern void	scr_secure (void);
   extern void	scr_set_tab (int value);
   extern void	scr_E (void);
   extern void	scr_fore_color (int color);
   extern void	scr_back_color (int color);
   extern void	mouse_report (XButtonEvent *event);
   /* mode selections */
   extern void	scr_autowrap (int mode);
   extern void	scr_relative_origin (int mode);
   extern void	scr_insert_mode (int mode);
   extern void	scr_rvideo_mode (int mode);
#ifdef PRINT_PIPE
   extern void	scr_printscreen (int fullhist);
#endif

#ifdef __cplusplus
}
#endif

#endif	/* whole file */
/*----------------------- end-of-file (C header) -----------------------*/
